/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.AbstractWebSocketSession;

public abstract class NettyWebSocketSessionSupport<T>
extends AbstractWebSocketSession<T> {
    public static final int DEFAULT_FRAME_MAX_SIZE = 65536;
    private static final Map<Class<?>, WebSocketMessage.Type> messageTypes = new HashMap(8);

    protected NettyWebSocketSessionSupport(T delegate, HandshakeInfo info, NettyDataBufferFactory factory) {
        super(delegate, ObjectUtils.getIdentityHexString(delegate), info, (DataBufferFactory)factory);
    }

    public NettyDataBufferFactory bufferFactory() {
        return (NettyDataBufferFactory)super.bufferFactory();
    }

    protected WebSocketMessage toMessage(WebSocketFrame frame) {
        NettyDataBuffer payload = this.bufferFactory().wrap(frame.content());
        WebSocketMessage.Type messageType = messageTypes.get(frame.getClass());
        Assert.state((messageType != null ? 1 : 0) != 0, (String)"Unexpected message type");
        return new WebSocketMessage(messageType, (DataBuffer)payload, frame);
    }

    protected WebSocketFrame toFrame(WebSocketMessage message) {
        if (message.getNativeMessage() != null) {
            return (WebSocketFrame)message.getNativeMessage();
        }
        ByteBuf byteBuf = NettyDataBufferFactory.toByteBuf((DataBuffer)message.getPayload());
        if (WebSocketMessage.Type.TEXT.equals((Object)message.getType())) {
            return new TextWebSocketFrame(byteBuf);
        }
        if (WebSocketMessage.Type.BINARY.equals((Object)message.getType())) {
            return new BinaryWebSocketFrame(byteBuf);
        }
        if (WebSocketMessage.Type.PING.equals((Object)message.getType())) {
            return new PingWebSocketFrame(byteBuf);
        }
        if (WebSocketMessage.Type.PONG.equals((Object)message.getType())) {
            return new PongWebSocketFrame(byteBuf);
        }
        throw new IllegalArgumentException("Unexpected message type: " + String.valueOf((Object)message.getType()));
    }

    static {
        messageTypes.put(TextWebSocketFrame.class, WebSocketMessage.Type.TEXT);
        messageTypes.put(BinaryWebSocketFrame.class, WebSocketMessage.Type.BINARY);
        messageTypes.put(PingWebSocketFrame.class, WebSocketMessage.Type.PING);
        messageTypes.put(PongWebSocketFrame.class, WebSocketMessage.Type.PONG);
    }
}

