/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.reactive.config.ResourceHandlerRegistration;
import org.springframework.web.reactive.handler.AbstractUrlHandlerMapping;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.resource.ResourceTransformer;
import org.springframework.web.reactive.resource.ResourceTransformerSupport;
import org.springframework.web.reactive.resource.ResourceUrlProvider;
import org.springframework.web.reactive.resource.ResourceWebHandler;

public class ResourceHandlerRegistry {
    private final ResourceLoader resourceLoader;
    private final List<ResourceHandlerRegistration> registrations = new ArrayList<ResourceHandlerRegistration>();
    private int order = 0x7FFFFFFE;
    private @Nullable ResourceUrlProvider resourceUrlProvider;

    public ResourceHandlerRegistry(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setResourceUrlProvider(@Nullable ResourceUrlProvider resourceUrlProvider) {
        this.resourceUrlProvider = resourceUrlProvider;
    }

    public ResourceHandlerRegistration addResourceHandler(String ... patterns) {
        ResourceHandlerRegistration registration = new ResourceHandlerRegistration(this.resourceLoader, patterns);
        this.registrations.add(registration);
        return registration;
    }

    public boolean hasMappingForPattern(String pathPattern) {
        for (ResourceHandlerRegistration registration : this.registrations) {
            if (!Arrays.asList(registration.getPathPatterns()).contains(pathPattern)) continue;
            return true;
        }
        return false;
    }

    public ResourceHandlerRegistry setOrder(int order) {
        this.order = order;
        return this;
    }

    protected @Nullable AbstractUrlHandlerMapping getHandlerMapping() {
        if (this.registrations.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, ResourceWebHandler> urlMap = new LinkedHashMap<String, ResourceWebHandler>();
        for (ResourceHandlerRegistration registration : this.registrations) {
            ResourceWebHandler handler = this.getRequestHandler(registration);
            for (String pathPattern : registration.getPathPatterns()) {
                urlMap.put(pathPattern, handler);
            }
        }
        return new SimpleUrlHandlerMapping(urlMap, this.order);
    }

    private ResourceWebHandler getRequestHandler(ResourceHandlerRegistration registration) {
        ResourceWebHandler handler = registration.getRequestHandler();
        for (ResourceTransformer transformer : handler.getResourceTransformers()) {
            if (!(transformer instanceof ResourceTransformerSupport)) continue;
            ResourceTransformerSupport resourceTransformerSupport = (ResourceTransformerSupport)transformer;
            resourceTransformerSupport.setResourceUrlProvider(this.resourceUrlProvider);
        }
        try {
            handler.afterPropertiesSet();
        }
        catch (Throwable ex) {
            throw new BeanInitializationException("Failed to init ResourceHttpRequestHandler", ex);
        }
        return handler;
    }
}

