/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SourceFilteringListener;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.i18n.SimpleLocaleContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.portlet.GenericPortletBean;
import org.springframework.web.portlet.context.ConfigurablePortletApplicationContext;
import org.springframework.web.portlet.context.PortletApplicationContextUtils;
import org.springframework.web.portlet.context.PortletRequestAttributes;
import org.springframework.web.portlet.context.PortletRequestHandledEvent;
import org.springframework.web.portlet.context.StandardPortletEnvironment;
import org.springframework.web.portlet.context.XmlPortletApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FrameworkPortlet
extends GenericPortletBean
implements ApplicationListener<ContextRefreshedEvent> {
    public static final Class<?> DEFAULT_CONTEXT_CLASS = XmlPortletApplicationContext.class;
    public static final String DEFAULT_NAMESPACE_SUFFIX = "-portlet";
    public static final String PORTLET_CONTEXT_PREFIX = FrameworkPortlet.class.getName() + ".CONTEXT.";
    public static final String[] DEFAULT_USERINFO_ATTRIBUTE_NAMES = new String[]{"user.login.id", "user.name"};
    private Class<?> contextClass = DEFAULT_CONTEXT_CLASS;
    private String namespace;
    private String contextConfigLocation;
    private boolean publishContext = true;
    private boolean publishEvents = true;
    private boolean threadContextInheritable = false;
    private String[] userinfoUsernameAttributes = DEFAULT_USERINFO_ATTRIBUTE_NAMES;
    private ApplicationContext portletApplicationContext;
    private boolean refreshEventReceived = false;

    public void setContextClass(Class<?> contextClass) {
        this.contextClass = contextClass;
    }

    public Class<?> getContextClass() {
        return this.contextClass;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace != null ? this.namespace : this.getPortletName() + DEFAULT_NAMESPACE_SUFFIX;
    }

    public void setContextConfigLocation(String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
    }

    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public void setPublishContext(boolean publishContext) {
        this.publishContext = publishContext;
    }

    public void setPublishEvents(boolean publishEvents) {
        this.publishEvents = publishEvents;
    }

    public void setThreadContextInheritable(boolean threadContextInheritable) {
        this.threadContextInheritable = threadContextInheritable;
    }

    public void setUserinfoUsernameAttributes(String[] userinfoUsernameAttributes) {
        this.userinfoUsernameAttributes = userinfoUsernameAttributes;
    }

    @Override
    protected final void initPortletBean() throws PortletException {
        this.getPortletContext().log("Initializing Spring FrameworkPortlet '" + this.getPortletName() + "'");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("FrameworkPortlet '" + this.getPortletName() + "': initialization started"));
        }
        long startTime = System.currentTimeMillis();
        try {
            this.portletApplicationContext = this.initPortletApplicationContext();
            this.initFrameworkPortlet();
        }
        catch (PortletException ex) {
            this.logger.error((Object)"Context initialization failed", (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.logger.error((Object)"Context initialization failed", (Throwable)ex);
            throw ex;
        }
        if (this.logger.isInfoEnabled()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            this.logger.info((Object)("FrameworkPortlet '" + this.getPortletName() + "': initialization completed in " + elapsedTime + " ms"));
        }
    }

    protected ApplicationContext initPortletApplicationContext() {
        ApplicationContext parent = PortletApplicationContextUtils.getWebApplicationContext(this.getPortletContext());
        ApplicationContext pac = this.createPortletApplicationContext(parent);
        if (!this.refreshEventReceived) {
            this.onRefresh(pac);
        }
        if (this.publishContext) {
            String attName = this.getPortletContextAttributeName();
            this.getPortletContext().setAttribute(attName, (Object)pac);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Published ApplicationContext of portlet '" + this.getPortletName() + "' as PortletContext attribute with name [" + attName + "]"));
            }
        }
        return pac;
    }

    protected ApplicationContext createPortletApplicationContext(ApplicationContext parent) {
        Class<?> contextClass = this.getContextClass();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Portlet with name '" + this.getPortletName() + "' will try to create custom ApplicationContext context of class '" + contextClass.getName() + "'" + ", using parent context [" + parent + "]"));
        }
        if (!ConfigurablePortletApplicationContext.class.isAssignableFrom(contextClass)) {
            throw new ApplicationContextException("Fatal initialization error in portlet with name '" + this.getPortletName() + "': custom ApplicationContext class [" + contextClass.getName() + "] is not of type ConfigurablePortletApplicationContext");
        }
        ConfigurablePortletApplicationContext pac = (ConfigurablePortletApplicationContext)BeanUtils.instantiateClass(contextClass);
        String portletContextName = this.getPortletContext().getPortletContextName();
        if (portletContextName != null) {
            pac.setId(ConfigurablePortletApplicationContext.APPLICATION_CONTEXT_ID_PREFIX + portletContextName + "." + this.getPortletName());
        } else {
            pac.setId(ConfigurablePortletApplicationContext.APPLICATION_CONTEXT_ID_PREFIX + this.getPortletName());
        }
        pac.setEnvironment(this.getEnvironment());
        pac.setParent(parent);
        pac.setPortletContext(this.getPortletContext());
        pac.setPortletConfig(this.getPortletConfig());
        pac.setNamespace(this.getNamespace());
        pac.setConfigLocation(this.getContextConfigLocation());
        pac.addApplicationListener((ApplicationListener)new SourceFilteringListener((Object)pac, (ApplicationListener)this));
        ConfigurableEnvironment env = pac.getEnvironment();
        if (env instanceof StandardPortletEnvironment) {
            ((StandardPortletEnvironment)env).initPropertySources(pac.getServletContext(), this.getPortletContext(), this.getPortletConfig());
        }
        this.postProcessPortletApplicationContext(pac);
        pac.refresh();
        return pac;
    }

    protected void postProcessPortletApplicationContext(ConfigurableApplicationContext pac) {
    }

    public String getPortletContextAttributeName() {
        return PORTLET_CONTEXT_PREFIX + this.getPortletName();
    }

    public final ApplicationContext getPortletApplicationContext() {
        return this.portletApplicationContext;
    }

    protected void initFrameworkPortlet() throws PortletException {
    }

    public void refresh() {
        ApplicationContext pac = this.getPortletApplicationContext();
        if (!(pac instanceof ConfigurableApplicationContext)) {
            throw new IllegalStateException("Portlet ApplicationContext does not support refresh: " + pac);
        }
        ((ConfigurableApplicationContext)pac).refresh();
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.refreshEventReceived = true;
        this.onRefresh(event.getApplicationContext());
    }

    protected void onRefresh(ApplicationContext context) {
    }

    protected String getTitle(RenderRequest renderRequest) {
        try {
            return super.getTitle(renderRequest);
        }
        catch (NullPointerException ex) {
            return this.getPortletName();
        }
    }

    public final void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response);
    }

    protected final void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response);
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response);
    }

    public void processEvent(EventRequest request, EventResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void processRequest(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        long startTime = System.currentTimeMillis();
        Throwable failureCause = null;
        LocaleContext previousLocaleContext = LocaleContextHolder.getLocaleContext();
        LocaleContextHolder.setLocaleContext((LocaleContext)this.buildLocaleContext(request), (boolean)this.threadContextInheritable);
        RequestAttributes previousRequestAttributes = RequestContextHolder.getRequestAttributes();
        PortletRequestAttributes requestAttributes = null;
        if (previousRequestAttributes == null || previousRequestAttributes.getClass().equals(PortletRequestAttributes.class) || previousRequestAttributes.getClass().equals(ServletRequestAttributes.class)) {
            requestAttributes = new PortletRequestAttributes(request);
            RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes, (boolean)this.threadContextInheritable);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Bound request context to thread: " + request));
        }
        try {
            try {
                String phase = (String)request.getAttribute("javax.portlet.lifecycle_phase");
                if ("ACTION_PHASE".equals(phase)) {
                    this.doActionService((ActionRequest)request, (ActionResponse)response);
                } else if ("RENDER_PHASE".equals(phase)) {
                    this.doRenderService((RenderRequest)request, (RenderResponse)response);
                } else if ("RESOURCE_PHASE".equals(phase)) {
                    this.doResourceService((ResourceRequest)request, (ResourceResponse)response);
                } else {
                    if (!"EVENT_PHASE".equals(phase)) throw new IllegalStateException("Invalid portlet request phase: " + phase);
                    this.doEventService((EventRequest)request, (EventResponse)response);
                }
                Object var11_12 = null;
            }
            catch (PortletException ex) {
                failureCause = ex;
                throw ex;
            }
            catch (IOException ex) {
                failureCause = ex;
                throw ex;
            }
            catch (Throwable ex) {
                failureCause = ex;
                throw new PortletException("Request processing failed", ex);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            LocaleContextHolder.setLocaleContext((LocaleContext)previousLocaleContext, (boolean)this.threadContextInheritable);
            if (requestAttributes != null) {
                RequestContextHolder.setRequestAttributes((RequestAttributes)previousRequestAttributes, (boolean)this.threadContextInheritable);
                requestAttributes.requestCompleted();
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Cleared thread-bound resource request context: " + request));
            }
            if (failureCause != null) {
                this.logger.error((Object)"Could not complete request", failureCause);
            } else {
                this.logger.debug((Object)"Successfully completed request");
            }
            if (!this.publishEvents) throw throwable;
            long processingTime = System.currentTimeMillis() - startTime;
            this.portletApplicationContext.publishEvent((ApplicationEvent)new PortletRequestHandledEvent((Object)this, this.getPortletConfig().getPortletName(), request.getPortletMode().toString(), request instanceof ActionRequest ? "action" : "render", request.getRequestedSessionId(), this.getUsernameForRequest(request), processingTime, failureCause));
            throw throwable;
        }
        LocaleContextHolder.setLocaleContext((LocaleContext)previousLocaleContext, (boolean)this.threadContextInheritable);
        if (requestAttributes != null) {
            RequestContextHolder.setRequestAttributes((RequestAttributes)previousRequestAttributes, (boolean)this.threadContextInheritable);
            requestAttributes.requestCompleted();
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Cleared thread-bound resource request context: " + request));
        }
        if (failureCause != null) {
            this.logger.error((Object)"Could not complete request", failureCause);
        } else {
            this.logger.debug((Object)"Successfully completed request");
        }
        if (!this.publishEvents) return;
        long processingTime = System.currentTimeMillis() - startTime;
        this.portletApplicationContext.publishEvent((ApplicationEvent)new PortletRequestHandledEvent((Object)this, this.getPortletConfig().getPortletName(), request.getPortletMode().toString(), request instanceof ActionRequest ? "action" : "render", request.getRequestedSessionId(), this.getUsernameForRequest(request), processingTime, failureCause));
    }

    protected LocaleContext buildLocaleContext(PortletRequest request) {
        return new SimpleLocaleContext(request.getLocale());
    }

    protected String getUsernameForRequest(PortletRequest request) {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal != null) {
            return userPrincipal.getName();
        }
        String userName = request.getRemoteUser();
        if (userName != null) {
            return userName;
        }
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        if (userInfo != null) {
            int n = this.userinfoUsernameAttributes.length;
            for (int i = 0; i < n; ++i) {
                userName = (String)userInfo.get(this.userinfoUsernameAttributes[i]);
                if (userName == null) continue;
                return userName;
            }
        }
        return null;
    }

    protected abstract void doActionService(ActionRequest var1, ActionResponse var2) throws Exception;

    protected abstract void doRenderService(RenderRequest var1, RenderResponse var2) throws Exception;

    protected abstract void doResourceService(ResourceRequest var1, ResourceResponse var2) throws Exception;

    protected abstract void doEventService(EventRequest var1, EventResponse var2) throws Exception;

    public void destroy() {
        this.getPortletContext().log("Destroying Spring FrameworkPortlet '" + this.getPortletName() + "'");
        if (this.portletApplicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.portletApplicationContext).close();
        }
    }
}

