/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.OptionWriter;
import org.springframework.web.servlet.tags.form.TagWriter;

public class SelectTag
extends AbstractHtmlInputElementTag {
    public static final String LIST_VALUE_PAGE_ATTRIBUTE = "org.springframework.web.servlet.tags.form.SelectTag.listValue";
    private static final Object EMPTY = new Object();
    private Object items;
    private String itemValue;
    private String itemLabel;
    private String size;
    private Object multiple = Boolean.FALSE;
    private TagWriter tagWriter;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    public void setItems(Object items) {
        this.items = items != null ? items : EMPTY;
    }

    protected Object getItems() {
        return this.items;
    }

    public void setItemValue(String itemValue) {
        this.itemValue = itemValue;
    }

    protected String getItemValue() {
        return this.itemValue;
    }

    public void setItemLabel(String itemLabel) {
        this.itemLabel = itemLabel;
    }

    protected String getItemLabel() {
        return this.itemLabel;
    }

    public void setSize(String size) {
        this.size = size;
    }

    protected String getSize() {
        return this.size;
    }

    public void setMultiple(Object multiple) {
        this.multiple = multiple;
    }

    protected Object getMultiple() {
        return this.multiple;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("select");
        this.writeDefaultAttributes(tagWriter);
        if (this.isMultiple()) {
            tagWriter.writeAttribute("multiple", "multiple");
        }
        tagWriter.writeOptionalAttributeValue("size", this.getDisplayString(this.evaluate("size", this.getSize())));
        Object items = this.getItems();
        if (items != null) {
            if (items != EMPTY) {
                Object itemsObject;
                Object object = itemsObject = items instanceof String ? this.evaluate("items", (String)items) : items;
                if (itemsObject != null) {
                    String valueProperty = this.getItemValue() != null ? ObjectUtils.getDisplayString((Object)this.evaluate("itemValue", this.getItemValue())) : null;
                    String labelProperty = this.getItemLabel() != null ? ObjectUtils.getDisplayString((Object)this.evaluate("itemLabel", this.getItemLabel())) : null;
                    OptionWriter optionWriter = new OptionWriter(itemsObject, this.getBindStatus(), valueProperty, labelProperty, this.isHtmlEscape());
                    optionWriter.writeOptions(tagWriter);
                }
            }
            tagWriter.endTag(true);
            this.writeHiddenTagIfNecessary(tagWriter);
            return 6;
        }
        tagWriter.forceBlock();
        this.tagWriter = tagWriter;
        this.pageContext.setAttribute(LIST_VALUE_PAGE_ATTRIBUTE, (Object)this.getBindStatus());
        return 1;
    }

    private void writeHiddenTagIfNecessary(TagWriter tagWriter) throws JspException {
        if (this.isMultiple()) {
            tagWriter.startTag("input");
            tagWriter.writeAttribute("type", "hidden");
            tagWriter.writeAttribute("name", "_" + this.getName());
            tagWriter.writeAttribute("value", "1");
            tagWriter.endTag();
        }
    }

    private boolean isMultiple() throws JspException {
        Object multiple = this.getMultiple();
        if (Boolean.TRUE.equals(multiple) || "true".equals(multiple) || "multiple".equals(multiple)) {
            return true;
        }
        if (this.multiple instanceof String) {
            Object evaluatedValue = this.evaluate("multiple", multiple);
            return Boolean.TRUE.equals(evaluatedValue);
        }
        return this.forceMultiple();
    }

    private boolean forceMultiple() throws JspException {
        Object editorValue;
        BindStatus bindStatus = this.getBindStatus();
        Class valueType = bindStatus.getValueType();
        if (valueType != null && SelectTag.typeRequiresMultiple(valueType)) {
            return true;
        }
        return bindStatus.getEditor() != null && (editorValue = bindStatus.getEditor().getValue()) != null && SelectTag.typeRequiresMultiple(editorValue.getClass());
    }

    private static boolean typeRequiresMultiple(Class type) {
        return type.isArray() || (class$java$util$Collection == null ? (class$java$util$Collection = SelectTag.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(type) || (class$java$util$Map == null ? (class$java$util$Map = SelectTag.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(type);
    }

    public int doEndTag() throws JspException {
        if (this.tagWriter != null) {
            this.tagWriter.endTag();
            this.writeHiddenTagIfNecessary(this.tagWriter);
        }
        return 6;
    }

    public void doFinally() {
        super.doFinally();
        this.tagWriter = null;
        this.pageContext.removeAttribute(LIST_VALUE_PAGE_ATTRIBUTE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

