/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.RequestContext;

public abstract class AbstractView
extends WebApplicationObjectSupport
implements View,
BeanNameAware {
    public static final String DEFAULT_CONTENT_TYPE = "text/html;charset=ISO-8859-1";
    private String beanName;
    private String contentType = "text/html;charset=ISO-8859-1";
    private String requestContextAttribute;
    private final Map staticAttributes = new HashMap();

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setRequestContextAttribute(String requestContextAttribute) {
        this.requestContextAttribute = requestContextAttribute;
    }

    public String getRequestContextAttribute() {
        return this.requestContextAttribute;
    }

    public void setAttributesCSV(String propString) throws IllegalArgumentException {
        if (propString != null) {
            StringTokenizer st = new StringTokenizer(propString, ",");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int eqIdx = tok.indexOf("=");
                if (eqIdx == -1) {
                    throw new IllegalArgumentException("Expected = in attributes CSV string '" + propString + "'");
                }
                if (eqIdx >= tok.length() - 2) {
                    throw new IllegalArgumentException("At least 2 characters ([]) required in attributes CSV string '" + propString + "'");
                }
                String name = tok.substring(0, eqIdx);
                String value = tok.substring(eqIdx + 1);
                value = value.substring(1);
                value = value.substring(0, value.length() - 1);
                this.addStaticAttribute(name, value);
            }
        }
    }

    public void setAttributes(Properties attributes) {
        CollectionUtils.mergePropertiesIntoMap((Properties)attributes, (Map)this.staticAttributes);
    }

    public void setAttributesMap(Map attributes) {
        if (attributes != null) {
            Iterator it = attributes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("Invalid attribute key [" + key + "]: only Strings allowed");
                }
                this.addStaticAttribute((String)key, entry.getValue());
            }
        }
    }

    public Map getAttributesMap() {
        return this.staticAttributes;
    }

    public void addStaticAttribute(String name, Object value) {
        this.staticAttributes.put(name, value);
    }

    public Map getStaticAttributes() {
        return Collections.unmodifiableMap(this.staticAttributes);
    }

    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering view with name '" + this.beanName + "' with model " + model + " and static attributes " + this.staticAttributes));
        }
        HashMap<String, RequestContext> mergedModel = new HashMap<String, RequestContext>(this.staticAttributes.size() + (model != null ? model.size() : 0));
        mergedModel.putAll(this.staticAttributes);
        if (model != null) {
            mergedModel.putAll(model);
        }
        if (this.requestContextAttribute != null) {
            mergedModel.put(this.requestContextAttribute, this.createRequestContext(request, mergedModel));
        }
        this.prepareResponse(request, response);
        this.renderMergedOutputModel(mergedModel, request, response);
    }

    protected RequestContext createRequestContext(HttpServletRequest request, Map model) {
        return new RequestContext(request, this.getServletContext(), model);
    }

    protected void prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        if (this.generatesDownloadContent()) {
            response.setHeader("Pragma", "private");
            response.setHeader("Cache-Control", "private, must-revalidate");
        }
    }

    protected boolean generatesDownloadContent() {
        return false;
    }

    protected abstract void renderMergedOutputModel(Map var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;

    protected void exposeModelAsRequestAttributes(Map model, HttpServletRequest request) throws Exception {
        Iterator it = model.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Invalid key [" + entry.getKey() + "] in model Map: only Strings allowed as model keys");
            }
            String modelName = (String)entry.getKey();
            Object modelValue = entry.getValue();
            if (modelValue != null) {
                request.setAttribute(modelName, modelValue);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added model object '" + modelName + "' of type [" + modelValue.getClass().getName() + "] to request in view with name '" + this.getBeanName() + "'"));
                continue;
            }
            request.removeAttribute(modelName);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Removed model object '" + modelName + "' from request in view with name '" + this.getBeanName() + "'"));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        if (this.getBeanName() != null) {
            sb.append(": name '").append(this.getBeanName()).append("'");
        } else {
            sb.append(": unnamed");
        }
        return sb.toString();
    }
}

