/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.web.servlet.tags.HtmlEscapingAwareTag;
import org.springframework.web.util.ExpressionEvaluationUtils;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.JavaScriptUtils;
import org.springframework.web.util.TagUtils;

public class EvalTag
extends HtmlEscapingAwareTag {
    private final ExpressionParser expressionParser = new SpelExpressionParser();
    private EvaluationContext evaluationContext;
    private Expression expression;
    private String var;
    private int scope = 1;
    private boolean javaScriptEscape = false;

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.evaluationContext = this.createEvaluationContext(pageContext);
    }

    public void setExpression(String expression) {
        this.expression = this.expressionParser.parseExpression(expression);
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = TagUtils.getScope((String)scope);
    }

    public void setJavaScriptEscape(String javaScriptEscape) throws JspException {
        this.javaScriptEscape = ExpressionEvaluationUtils.evaluateBoolean((String)"javaScriptEscape", (String)javaScriptEscape, (PageContext)this.pageContext);
    }

    public int doStartTagInternal() throws JspException {
        return 1;
    }

    public int doEndTag() throws JspException {
        if (this.var == null) {
            try {
                String result = (String)this.expression.getValue(this.evaluationContext, String.class);
                result = this.isHtmlEscape() ? HtmlUtils.htmlEscape((String)result) : result;
                result = this.javaScriptEscape ? JavaScriptUtils.javaScriptEscape((String)result) : result;
                this.pageContext.getOut().print(result);
            }
            catch (IOException ex) {
                throw new JspException((Throwable)ex);
            }
        } else {
            Object result = this.expression.getValue(this.evaluationContext);
            this.pageContext.setAttribute(this.var, result, this.scope);
        }
        return 6;
    }

    private EvaluationContext createEvaluationContext(PageContext pageContext) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.addPropertyAccessor((PropertyAccessor)new JspPropertyAccessor(pageContext));
        ConversionService conversionService = this.getConversionService(pageContext);
        if (conversionService != null) {
            context.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
        }
        return context;
    }

    private ConversionService getConversionService(PageContext pageContext) {
        return (ConversionService)pageContext.getRequest().getAttribute(ConversionService.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JspPropertyAccessor
    implements PropertyAccessor {
        private final PageContext pageContext;

        public JspPropertyAccessor(PageContext pageContext) {
            this.pageContext = pageContext;
        }

        public Class<?>[] getSpecificTargetClasses() {
            return null;
        }

        public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
            return this.resolveImplicitVariable(name) != null || this.pageContext.findAttribute(name) != null;
        }

        public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
            Object implicitVar = this.resolveImplicitVariable(name);
            if (implicitVar != null) {
                return new TypedValue(implicitVar);
            }
            return new TypedValue(this.pageContext.findAttribute(name));
        }

        public boolean canWrite(EvaluationContext context, Object target, String name) {
            return false;
        }

        public void write(EvaluationContext context, Object target, String name, Object newValue) {
            throw new UnsupportedOperationException();
        }

        private Object resolveImplicitVariable(String name) throws AccessException {
            try {
                return this.pageContext.getVariableResolver().resolveVariable(name);
            }
            catch (Exception ex) {
                throw new AccessException("Unexpected exception occurred accessing '" + name + "' as an implicit variable", ex);
            }
        }
    }
}

