/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.AbstractView;

public class MappingJackson2JsonView
extends AbstractView {
    public static final String DEFAULT_CONTENT_TYPE = "application/json";
    private ObjectMapper objectMapper = new ObjectMapper();
    private JsonEncoding encoding = JsonEncoding.UTF8;
    private String jsonPrefix;
    private Boolean prettyPrint;
    private Set<String> modelKeys;
    private boolean extractValueFromSingleKeyModel = false;
    private boolean disableCaching = true;
    private boolean updateContentLength = false;

    public MappingJackson2JsonView() {
        this.setContentType(DEFAULT_CONTENT_TYPE);
        this.setExposePathVariables(false);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null");
        this.objectMapper = objectMapper;
        this.configurePrettyPrint();
    }

    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setEncoding(JsonEncoding encoding) {
        Assert.notNull((Object)encoding, (String)"'encoding' must not be null");
        this.encoding = encoding;
    }

    public final JsonEncoding getEncoding() {
        return this.encoding;
    }

    public void setJsonPrefix(String jsonPrefix) {
        this.jsonPrefix = jsonPrefix;
    }

    public void setPrefixJson(boolean prefixJson) {
        this.jsonPrefix = prefixJson ? "{} && " : null;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        this.configurePrettyPrint();
    }

    private void configurePrettyPrint() {
        if (this.prettyPrint != null) {
            this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, this.prettyPrint.booleanValue());
        }
    }

    public void setModelKey(String modelKey) {
        this.modelKeys = Collections.singleton(modelKey);
    }

    public void setModelKeys(Set<String> modelKeys) {
        this.modelKeys = modelKeys;
    }

    public final Set<String> getModelKeys() {
        return this.modelKeys;
    }

    @Deprecated
    public void setRenderedAttributes(Set<String> renderedAttributes) {
        this.modelKeys = renderedAttributes;
    }

    @Deprecated
    public final Set<String> getRenderedAttributes() {
        return this.modelKeys;
    }

    public void setExtractValueFromSingleKeyModel(boolean extractValueFromSingleKeyModel) {
        this.extractValueFromSingleKeyModel = extractValueFromSingleKeyModel;
    }

    public void setDisableCaching(boolean disableCaching) {
        this.disableCaching = disableCaching;
    }

    public void setUpdateContentLength(boolean updateContentLength) {
        this.updateContentLength = updateContentLength;
    }

    @Override
    protected void prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        this.setResponseContentType(request, response);
        response.setCharacterEncoding(this.encoding.getJavaName());
        if (this.disableCaching) {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "no-cache, no-store, max-age=0");
            response.addDateHeader("Expires", 1L);
        }
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ByteArrayOutputStream stream = this.updateContentLength ? this.createTemporaryOutputStream() : response.getOutputStream();
        Object value = this.filterModel(model);
        this.writeContent(stream, value, this.jsonPrefix);
        if (this.updateContentLength) {
            this.writeToResponse(response, stream);
        }
    }

    protected Object filterModel(Map<String, Object> model) {
        HashMap<String, Object> result = new HashMap<String, Object>(model.size());
        Set<String> renderedAttributes = !CollectionUtils.isEmpty(this.modelKeys) ? this.modelKeys : model.keySet();
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            if (entry.getValue() instanceof BindingResult || !renderedAttributes.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return this.extractValueFromSingleKeyModel && result.size() == 1 ? result.values().iterator().next() : result;
    }

    protected void writeContent(OutputStream stream, Object value, String jsonPrefix) throws IOException {
        JsonGenerator generator = this.objectMapper.getJsonFactory().createJsonGenerator(stream, this.encoding);
        if (this.objectMapper.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            generator.useDefaultPrettyPrinter();
        }
        if (jsonPrefix != null) {
            generator.writeRaw(jsonPrefix);
        }
        this.objectMapper.writeValue(generator, value);
    }
}

