/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.json.AbstractJackson2View;

public class MappingJackson2JsonView
extends AbstractJackson2View {
    public static final String DEFAULT_CONTENT_TYPE = "application/json";
    public static final String DEFAULT_JSONP_CONTENT_TYPE = "application/javascript";
    private String jsonPrefix;
    private Set<String> modelKeys;
    private boolean extractValueFromSingleKeyModel = false;
    private Set<String> jsonpParameterNames = new LinkedHashSet<String>(Arrays.asList("jsonp", "callback"));

    public MappingJackson2JsonView() {
        super(Jackson2ObjectMapperBuilder.json().build(), DEFAULT_CONTENT_TYPE);
    }

    public void setJsonPrefix(String jsonPrefix) {
        this.jsonPrefix = jsonPrefix;
    }

    public void setPrefixJson(boolean prefixJson) {
        this.jsonPrefix = prefixJson ? ")]}', " : null;
    }

    @Override
    public void setModelKey(String modelKey) {
        this.modelKeys = Collections.singleton(modelKey);
    }

    public void setModelKeys(Set<String> modelKeys) {
        this.modelKeys = modelKeys;
    }

    public final Set<String> getModelKeys() {
        return this.modelKeys;
    }

    public void setExtractValueFromSingleKeyModel(boolean extractValueFromSingleKeyModel) {
        this.extractValueFromSingleKeyModel = extractValueFromSingleKeyModel;
    }

    public void setJsonpParameterNames(Set<String> jsonpParameterNames) {
        this.jsonpParameterNames = jsonpParameterNames;
    }

    private String getJsonpParameterValue(HttpServletRequest request) {
        if (this.jsonpParameterNames != null) {
            for (String name : this.jsonpParameterNames) {
                String value = request.getParameter(name);
                if (StringUtils.isEmpty((Object)value)) continue;
                return value;
            }
        }
        return null;
    }

    @Override
    protected Object filterModel(Map<String, Object> model) {
        HashMap<String, Object> result = new HashMap<String, Object>(model.size());
        Set<String> modelKeys = !CollectionUtils.isEmpty(this.modelKeys) ? this.modelKeys : model.keySet();
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            if (entry.getValue() instanceof BindingResult || !modelKeys.contains(entry.getKey()) || entry.getKey().equals(JsonView.class.getName()) || entry.getKey().equals(FilterProvider.class.getName())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return this.extractValueFromSingleKeyModel && result.size() == 1 ? result.values().iterator().next() : result;
    }

    @Override
    protected Object filterAndWrapModel(Map<String, Object> model, HttpServletRequest request) {
        Object value = super.filterAndWrapModel(model, request);
        String jsonpParameterValue = this.getJsonpParameterValue(request);
        if (jsonpParameterValue != null) {
            if (value instanceof MappingJacksonValue) {
                ((MappingJacksonValue)value).setJsonpFunction(jsonpParameterValue);
            } else {
                MappingJacksonValue container = new MappingJacksonValue(value);
                container.setJsonpFunction(jsonpParameterValue);
                value = container;
            }
        }
        return value;
    }

    @Override
    protected void writePrefix(JsonGenerator generator, Object object) throws IOException {
        if (this.jsonPrefix != null) {
            generator.writeRaw(this.jsonPrefix);
        }
        String jsonpFunction = null;
        if (object instanceof MappingJacksonValue) {
            jsonpFunction = ((MappingJacksonValue)object).getJsonpFunction();
        }
        if (jsonpFunction != null) {
            generator.writeRaw(jsonpFunction + "(");
        }
    }

    @Override
    protected void writeSuffix(JsonGenerator generator, Object object) throws IOException {
        String jsonpFunction = null;
        if (object instanceof MappingJacksonValue) {
            jsonpFunction = ((MappingJacksonValue)object).getJsonpFunction();
        }
        if (jsonpFunction != null) {
            generator.writeRaw(");");
        }
    }

    @Override
    protected void setResponseContentType(HttpServletRequest request, HttpServletResponse response) {
        if (this.getJsonpParameterValue(request) != null) {
            response.setContentType(DEFAULT_JSONP_CONTENT_TYPE);
        } else {
            super.setResponseContentType(request, response);
        }
    }
}

