/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.multiaction;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.web.servlet.mvc.multiaction.AbstractUrlMethodNameResolver;
import org.springframework.web.util.WebUtils;

public class InternalPathMethodNameResolver
extends AbstractUrlMethodNameResolver {
    private String prefix = "";
    private String suffix = "";
    private final Map<String, String> methodNameCache = new ConcurrentHashMap<String, String>(16);

    public void setPrefix(String prefix) {
        this.prefix = prefix != null ? prefix : "";
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix != null ? suffix : "";
    }

    protected String getSuffix() {
        return this.suffix;
    }

    @Override
    protected String getHandlerMethodNameForUrlPath(String urlPath) {
        String methodName = this.methodNameCache.get(urlPath);
        if (methodName == null) {
            methodName = this.extractHandlerMethodNameFromUrlPath(urlPath);
            methodName = this.postProcessHandlerMethodName(methodName);
            this.methodNameCache.put(urlPath, methodName);
        }
        return methodName;
    }

    protected String extractHandlerMethodNameFromUrlPath(String uri) {
        return WebUtils.extractFilenameFromUrlPath((String)uri);
    }

    protected String postProcessHandlerMethodName(String methodName) {
        return this.getPrefix() + methodName + this.getSuffix();
    }
}

