/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.web.ErrorResponse;
import org.springframework.web.ErrorResponseException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;

public abstract class ResponseEntityExceptionHandler {
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    protected final Log logger = LogFactory.getLog(this.getClass());

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class, HttpMediaTypeNotSupportedException.class, HttpMediaTypeNotAcceptableException.class, MissingPathVariableException.class, MissingServletRequestParameterException.class, MissingServletRequestPartException.class, ServletRequestBindingException.class, MethodArgumentNotValidException.class, NoHandlerFoundException.class, AsyncRequestTimeoutException.class, ErrorResponseException.class, ConversionNotSupportedException.class, TypeMismatchException.class, HttpMessageNotReadableException.class, HttpMessageNotWritableException.class, BindException.class})
    @Nullable
    public final ResponseEntity<Object> handleException(Exception ex, WebRequest request) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        if (ex instanceof ErrorResponse) {
            ErrorResponse errorEx = (ErrorResponse)ex;
            if (ex instanceof HttpRequestMethodNotSupportedException) {
                HttpRequestMethodNotSupportedException subEx = (HttpRequestMethodNotSupportedException)ex;
                return this.handleHttpRequestMethodNotSupported(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof HttpMediaTypeNotSupportedException) {
                HttpMediaTypeNotSupportedException subEx = (HttpMediaTypeNotSupportedException)ex;
                return this.handleHttpMediaTypeNotSupported(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof HttpMediaTypeNotAcceptableException) {
                HttpMediaTypeNotAcceptableException subEx = (HttpMediaTypeNotAcceptableException)((Object)ex);
                return this.handleHttpMediaTypeNotAcceptable(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof MissingPathVariableException) {
                MissingPathVariableException subEx = (MissingPathVariableException)ex;
                return this.handleMissingPathVariable(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof MissingServletRequestParameterException) {
                MissingServletRequestParameterException subEx = (MissingServletRequestParameterException)ex;
                return this.handleMissingServletRequestParameter(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof MissingServletRequestPartException) {
                MissingServletRequestPartException subEx = (MissingServletRequestPartException)ex;
                return this.handleMissingServletRequestPart(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof ServletRequestBindingException) {
                ServletRequestBindingException subEx = (ServletRequestBindingException)ex;
                return this.handleServletRequestBindingException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof MethodArgumentNotValidException) {
                MethodArgumentNotValidException subEx = (MethodArgumentNotValidException)ex;
                return this.handleMethodArgumentNotValid(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof NoHandlerFoundException) {
                NoHandlerFoundException subEx = (NoHandlerFoundException)((Object)ex);
                return this.handleNoHandlerFoundException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            if (ex instanceof AsyncRequestTimeoutException) {
                AsyncRequestTimeoutException subEx = (AsyncRequestTimeoutException)ex;
                return this.handleAsyncRequestTimeoutException(subEx, subEx.getHeaders(), subEx.getStatusCode(), request);
            }
            return this.handleExceptionInternal(ex, null, errorEx.getHeaders(), errorEx.getStatusCode(), request);
        }
        if (ex instanceof ConversionNotSupportedException) {
            ConversionNotSupportedException cnse = (ConversionNotSupportedException)ex;
            return this.handleConversionNotSupported(cnse, headers, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, request);
        }
        if (ex instanceof TypeMismatchException) {
            TypeMismatchException tme = (TypeMismatchException)ex;
            return this.handleTypeMismatch(tme, headers, (HttpStatusCode)HttpStatus.BAD_REQUEST, request);
        }
        if (ex instanceof HttpMessageNotReadableException) {
            HttpMessageNotReadableException hmnre = (HttpMessageNotReadableException)ex;
            return this.handleHttpMessageNotReadable(hmnre, headers, (HttpStatusCode)HttpStatus.BAD_REQUEST, request);
        }
        if (ex instanceof HttpMessageNotWritableException) {
            HttpMessageNotWritableException hmnwe = (HttpMessageNotWritableException)ex;
            return this.handleHttpMessageNotWritable(hmnwe, headers, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, request);
        }
        if (ex instanceof BindException) {
            BindException be = (BindException)ex;
            return this.handleBindException(be, headers, (HttpStatusCode)HttpStatus.BAD_REQUEST, request);
        }
        throw ex;
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        pageNotFoundLogger.warn((Object)ex.getMessage());
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpMediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMissingPathVariable(MissingPathVariableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMissingServletRequestPart(MissingServletRequestPartException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleServletRequestBindingException(ServletRequestBindingException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleNoHandlerFoundException(NoHandlerFoundException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)((Object)ex), null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleAsyncRequestTimeoutException(AsyncRequestTimeoutException ex, HttpHeaders headers, HttpStatusCode status, WebRequest webRequest) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, webRequest);
    }

    @Nullable
    protected ResponseEntity<Object> handleConversionNotSupported(ConversionNotSupportedException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleTypeMismatch(TypeMismatchException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleHttpMessageNotWritable(HttpMessageNotWritableException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleBindException(BindException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, null, headers, status, request);
    }

    @Nullable
    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, @Nullable Object body2, HttpHeaders headers, HttpStatusCode statusCode, WebRequest webRequest) {
        ServletWebRequest servletWebRequest;
        HttpServletResponse response;
        if (webRequest instanceof ServletWebRequest && (response = (servletWebRequest = (ServletWebRequest)webRequest).getResponse()) != null && response.isCommitted()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Ignoring exception, response committed. : " + ex));
            }
            return null;
        }
        if (HttpStatus.INTERNAL_SERVER_ERROR.equals((Object)statusCode)) {
            webRequest.setAttribute("jakarta.servlet.error.exception", (Object)ex, 0);
        }
        if (body2 == null && ex instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)ex;
            body2 = errorResponse.getBody();
        }
        return new ResponseEntity(body2, (MultiValueMap)headers, statusCode);
    }
}

