/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResource;

public abstract class ResourceHandlerUtils {
    private static final Log logger = LogFactory.getLog(ResourceHandlerUtils.class);
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";

    public static void assertResourceLocation(@Nullable Resource location) {
        Assert.notNull((Object)location, (String)"Resource location must not be null");
        try {
            String path;
            if (location instanceof UrlResource) {
                path = location.getURL().toExternalForm();
            } else if (location instanceof ClassPathResource) {
                ClassPathResource classPathResource = (ClassPathResource)location;
                path = classPathResource.getPath();
            } else {
                path = location.getURL().getPath();
            }
            ResourceHandlerUtils.assertLocationPath(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void assertLocationPath(@Nullable String path) {
        Assert.notNull((Object)path, (String)"Resource location path must not be null");
        Assert.isTrue((path.endsWith(FOLDER_SEPARATOR) || path.endsWith(WINDOWS_FOLDER_SEPARATOR) ? 1 : 0) != 0, (String)("Resource location does not end with slash: " + path));
    }

    public static String normalizeInputPath(String path) {
        path = StringUtils.replace((String)path, (String)WINDOWS_FOLDER_SEPARATOR, (String)FOLDER_SEPARATOR);
        path = ResourceHandlerUtils.cleanDuplicateSlashes(path);
        return ResourceHandlerUtils.cleanLeadingSlash(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String cleanDuplicateSlashes(String path) {
        StringBuilder sb = null;
        char prev = '\u0000';
        for (int i2 = 0; i2 < path.length(); ++i2) {
            char curr = path.charAt(i2);
            try {
                if (curr == '/' && prev == '/') {
                    if (sb != null) continue;
                    sb = new StringBuilder(path.substring(0, i2));
                    continue;
                }
                if (sb == null) continue;
                sb.append(path.charAt(i2));
                continue;
            }
            finally {
                prev = curr;
            }
        }
        return sb != null ? sb.toString() : path;
    }

    private static String cleanLeadingSlash(String path) {
        boolean slash = false;
        for (int i2 = 0; i2 < path.length(); ++i2) {
            if (path.charAt(i2) == '/') {
                slash = true;
                continue;
            }
            if (path.charAt(i2) <= ' ' || path.charAt(i2) == '\u007f') continue;
            if (i2 == 0 || i2 == 1 && slash) {
                return path;
            }
            return slash ? FOLDER_SEPARATOR + path.substring(i2) : path.substring(i2);
        }
        return slash ? FOLDER_SEPARATOR : "";
    }

    public static boolean shouldIgnoreInputPath(String path) {
        return !StringUtils.hasText((String)path) || ResourceHandlerUtils.isInvalidPath(path) || ResourceHandlerUtils.isInvalidEncodedPath(path);
    }

    public static boolean isInvalidPath(String path) {
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)LogFormatUtils.formatValue((Object)("Path with \"WEB-INF\" or \"META-INF\": [" + path + "]"), (int)-1, (boolean)true));
            }
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl((String)relativePath) || relativePath.startsWith("url:")) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)LogFormatUtils.formatValue((Object)("Path represents URL or has \"url:\" prefix: [" + path + "]"), (int)-1, (boolean)true));
                }
                return true;
            }
        }
        if (path.contains("../")) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)LogFormatUtils.formatValue((Object)("Path contains \"../\" after call to StringUtils#cleanPath: [" + path + "]"), (int)-1, (boolean)true));
            }
            return true;
        }
        return false;
    }

    private static boolean isInvalidEncodedPath(String path) {
        if (path.contains("%")) {
            String decodedPath = ResourceHandlerUtils.decode(path);
            if (decodedPath.contains("%")) {
                decodedPath = ResourceHandlerUtils.decode(decodedPath);
            }
            if (ResourceHandlerUtils.isInvalidPath(decodedPath)) {
                return true;
            }
            decodedPath = ResourceHandlerUtils.normalizeInputPath(decodedPath);
            return ResourceHandlerUtils.isInvalidPath(decodedPath);
        }
        return false;
    }

    private static String decode(String path) {
        try {
            return URLDecoder.decode(path, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static boolean isResourceUnderLocation(Resource location, Resource resource) throws IOException {
        String locationPath;
        String resourcePath;
        if (resource.getClass() != location.getClass()) {
            return false;
        }
        if (resource instanceof UrlResource) {
            resourcePath = resource.getURL().toExternalForm();
            locationPath = StringUtils.cleanPath((String)location.getURL().toString());
        } else if (resource instanceof ClassPathResource) {
            ClassPathResource classPathResource = (ClassPathResource)resource;
            resourcePath = classPathResource.getPath();
            locationPath = StringUtils.cleanPath((String)((ClassPathResource)location).getPath());
        } else if (resource instanceof ServletContextResource) {
            ServletContextResource servletContextResource = (ServletContextResource)resource;
            resourcePath = servletContextResource.getPath();
            locationPath = StringUtils.cleanPath((String)((ServletContextResource)location).getPath());
        } else {
            resourcePath = resource.getURL().getPath();
            locationPath = StringUtils.cleanPath((String)location.getURL().getPath());
        }
        if (locationPath.equals(resourcePath)) {
            return true;
        }
        locationPath = locationPath.endsWith(FOLDER_SEPARATOR) || locationPath.isEmpty() ? locationPath : locationPath + FOLDER_SEPARATOR;
        return resourcePath.startsWith(locationPath) && !ResourceHandlerUtils.isInvalidEncodedResourcePath(resourcePath);
    }

    private static boolean isInvalidEncodedResourcePath(String resourcePath) {
        if (resourcePath.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(resourcePath, StandardCharsets.UTF_8);
                if (decodedPath.contains("../") || decodedPath.contains("..\\")) {
                    logger.warn((Object)LogFormatUtils.formatValue((Object)("Resolved resource path contains encoded \"../\" or \"..\\\": " + resourcePath), (int)-1, (boolean)true));
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }
}

