/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.SmartView;
import org.springframework.web.servlet.view.DefaultFragmentsRenderingBuilder;

public interface FragmentsRendering
extends SmartView {
    @Nullable
    public HttpStatusCode status();

    public HttpHeaders headers();

    public Collection<ModelAndView> fragments();

    public static Builder fragment(String viewName) {
        return new DefaultFragmentsRenderingBuilder().fragment(viewName);
    }

    public static Builder fragment(String viewName, Map<String, Object> model) {
        return new DefaultFragmentsRenderingBuilder().fragment(viewName, (Map)model);
    }

    public static Builder fragments(Collection<ModelAndView> fragments) {
        return new DefaultFragmentsRenderingBuilder().fragments((Collection)fragments);
    }

    @Deprecated(since="6.2.13", forRemoval=true)
    public static Builder with(String viewName, Map<String, Object> model) {
        return FragmentsRendering.fragment(viewName, model);
    }

    @Deprecated(since="6.2.13", forRemoval=true)
    public static Builder with(String viewName) {
        return FragmentsRendering.fragment(viewName);
    }

    @Deprecated(since="6.2.13", forRemoval=true)
    public static Builder with(Collection<ModelAndView> fragments) {
        return FragmentsRendering.fragments(fragments);
    }

    public static interface Builder {
        public Builder status(HttpStatusCode var1);

        public Builder header(String var1, String ... var2);

        public Builder headers(Consumer<HttpHeaders> var1);

        public Builder fragment(String var1, Map<String, Object> var2);

        public Builder fragment(String var1);

        public Builder fragment(ModelAndView var1);

        public Builder fragments(Collection<ModelAndView> var1);

        public FragmentsRendering build();
    }
}

