/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.session;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.ServerHttpAsyncRequestControl;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsException;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;
import org.springframework.web.socket.sockjs.frame.SockJsFrame;
import org.springframework.web.socket.sockjs.frame.SockJsFrameFormat;
import org.springframework.web.socket.sockjs.transport.SockJsServiceConfig;
import org.springframework.web.socket.sockjs.transport.session.AbstractSockJsSession;

public abstract class AbstractHttpSockJsSession
extends AbstractSockJsSession {
    private volatile URI uri;
    private volatile HttpHeaders handshakeHeaders;
    private volatile Principal principal;
    private volatile InetSocketAddress localAddress;
    private volatile InetSocketAddress remoteAddress;
    private volatile String acceptedProtocol;
    private volatile ServerHttpResponse response;
    private volatile ServerHttpAsyncRequestControl asyncRequestControl;
    private volatile SockJsFrameFormat frameFormat;
    private volatile boolean requestInitialized;
    private final Queue<String> messageCache;

    public AbstractHttpSockJsSession(String id, SockJsServiceConfig config, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        super(id, config, wsHandler, attributes);
        this.messageCache = new LinkedBlockingQueue<String>(config.getHttpMessageCacheSize());
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public HttpHeaders getHandshakeHeaders() {
        return this.handshakeHeaders;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setAcceptedProtocol(String protocol) {
        this.acceptedProtocol = protocol;
    }

    @Override
    public String getAcceptedProtocol() {
        return this.acceptedProtocol;
    }

    protected ServerHttpResponse getResponse() {
        return this.response;
    }

    protected Queue<String> getMessageCache() {
        return this.messageCache;
    }

    @Override
    public boolean isActive() {
        ServerHttpAsyncRequestControl control = this.asyncRequestControl;
        return control != null && !control.isCompleted();
    }

    @Override
    public void setTextMessageSizeLimit(int messageSizeLimit) {
    }

    @Override
    public int getTextMessageSizeLimit() {
        return -1;
    }

    @Override
    public void setBinaryMessageSizeLimit(int messageSizeLimit) {
    }

    @Override
    public int getBinaryMessageSizeLimit() {
        return -1;
    }

    @Override
    public List<WebSocketExtension> getExtensions() {
        return Collections.emptyList();
    }

    public void handleInitialRequest(ServerHttpRequest request, ServerHttpResponse response, SockJsFrameFormat frameFormat) throws SockJsException {
        this.initRequest(request, response, frameFormat);
        this.uri = request.getURI();
        this.handshakeHeaders = request.getHeaders();
        this.principal = request.getPrincipal();
        this.localAddress = request.getLocalAddress();
        this.remoteAddress = request.getRemoteAddress();
        try {
            this.writePrelude(request, response);
            this.writeFrame(SockJsFrame.openFrame());
        }
        catch (Throwable ex) {
            this.tryCloseWithSockJsTransportError(ex, CloseStatus.SERVER_ERROR);
            throw new SockJsTransportFailureException("Failed to send \"open\" frame", this.getId(), ex);
        }
        try {
            this.requestInitialized = true;
            this.delegateConnectionEstablished();
        }
        catch (Throwable ex) {
            throw new SockJsException("Unhandled exception from WebSocketHandler", this.getId(), ex);
        }
    }

    private void initRequest(ServerHttpRequest request, ServerHttpResponse response, SockJsFrameFormat frameFormat) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Assert.notNull((Object)response, (String)"Response must not be null");
        Assert.notNull((Object)frameFormat, (String)"SockJsFrameFormat must not be null");
        this.response = response;
        this.frameFormat = frameFormat;
        this.asyncRequestControl = request.getAsyncRequestControl(response);
    }

    protected void writePrelude(ServerHttpRequest request, ServerHttpResponse response) throws IOException {
    }

    public void handleSuccessiveRequest(ServerHttpRequest request, ServerHttpResponse response, SockJsFrameFormat frameFormat) throws SockJsException {
        this.initRequest(request, response, frameFormat);
        try {
            this.writePrelude(request, response);
        }
        catch (Throwable ex) {
            this.tryCloseWithSockJsTransportError(ex, CloseStatus.SERVER_ERROR);
            throw new SockJsTransportFailureException("Failed to send \"open\" frame", this.getId(), ex);
        }
        this.startAsyncRequest();
    }

    protected void startAsyncRequest() throws SockJsException {
        try {
            this.asyncRequestControl.start(-1L);
            this.requestInitialized = true;
            this.scheduleHeartbeat();
            this.tryFlushCache();
        }
        catch (Throwable ex) {
            this.tryCloseWithSockJsTransportError(ex, CloseStatus.SERVER_ERROR);
            throw new SockJsTransportFailureException("Failed to flush messages", this.getId(), ex);
        }
    }

    @Override
    protected final void sendMessageInternal(String message) throws SockJsTransportFailureException {
        this.messageCache.add(message);
        this.tryFlushCache();
    }

    private void tryFlushCache() throws SockJsTransportFailureException {
        if (this.messageCache.isEmpty()) {
            this.logger.trace((Object)"Nothing to flush");
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.messageCache.size() + " message(s) to flush"));
        }
        if (this.isActive() && this.requestInitialized) {
            this.logger.trace((Object)"Flushing messages");
            this.flushCache();
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Not ready to flush");
        }
    }

    protected abstract void flushCache() throws SockJsTransportFailureException;

    @Override
    protected void disconnect(CloseStatus status) {
        this.resetRequest();
    }

    protected void resetRequest() {
        ServerHttpAsyncRequestControl control;
        this.requestInitialized = false;
        this.updateLastActiveTime();
        if (this.isActive() && (control = this.asyncRequestControl).isStarted()) {
            try {
                this.logger.debug((Object)"Completing asynchronous request");
                control.complete();
            }
            catch (Throwable ex) {
                this.logger.error((Object)("Failed to complete request: " + ex.getMessage()));
            }
        }
        this.response = null;
        this.asyncRequestControl = null;
    }

    @Override
    protected void writeFrameInternal(SockJsFrame frame) throws IOException {
        if (this.isActive()) {
            frame = this.frameFormat.format(frame);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Writing " + frame));
            }
            this.getResponse().getBody().write(frame.getContentBytes());
        }
    }
}

