/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.action.Actions;
import org.springframework.statemachine.action.SpelExpressionAction;
import org.springframework.statemachine.config.model.AbstractStateMachineModelFactory;
import org.springframework.statemachine.config.model.ChoiceData;
import org.springframework.statemachine.config.model.DefaultStateMachineModel;
import org.springframework.statemachine.config.model.EntryData;
import org.springframework.statemachine.config.model.ExitData;
import org.springframework.statemachine.config.model.HistoryData;
import org.springframework.statemachine.config.model.JunctionData;
import org.springframework.statemachine.config.model.StateData;
import org.springframework.statemachine.config.model.StateMachineModel;
import org.springframework.statemachine.config.model.StatesData;
import org.springframework.statemachine.config.model.TransitionData;
import org.springframework.statemachine.config.model.TransitionsData;
import org.springframework.statemachine.data.RepositoryAction;
import org.springframework.statemachine.data.RepositoryGuard;
import org.springframework.statemachine.data.RepositoryState;
import org.springframework.statemachine.data.RepositoryTransition;
import org.springframework.statemachine.data.StateRepository;
import org.springframework.statemachine.data.TransitionRepository;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.guard.Guards;
import org.springframework.statemachine.guard.SpelExpressionGuard;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.transition.TransitionKind;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class RepositoryStateMachineModelFactory
extends AbstractStateMachineModelFactory<String, String> {
    private final StateRepository<? extends RepositoryState> stateRepository;
    private final TransitionRepository<? extends RepositoryTransition> transitionRepository;

    public RepositoryStateMachineModelFactory(StateRepository<? extends RepositoryState> stateRepository, TransitionRepository<? extends RepositoryTransition> transitionRepository) {
        this.stateRepository = stateRepository;
        this.transitionRepository = transitionRepository;
    }

    public StateMachineModel<String, String> build() {
        return this.build(null);
    }

    /*
     * WARNING - void declaration
     */
    public StateMachineModel<String, String> build(String machineId) {
        ArrayList<Object> stateDatas = new ArrayList<Object>();
        for (RepositoryState repositoryState : this.stateRepository.findByMachineId(machineId == null ? "" : machineId)) {
            void var13_14;
            StateMachineModel<String, String> subStateMachineModel = null;
            String submachineId = repositoryState.getSubmachineId();
            if (submachineId != null) {
                subStateMachineModel = this.build(submachineId);
            }
            Collection<Function<StateContext<String, String>, Mono<Void>>> stateActions = this.loadStateActionsFromRepositoryState(repositoryState.getStateActions());
            Collection<Function<StateContext<String, String>, Mono<Void>>> entryActions = this.loadStateActionsFromRepositoryState(repositoryState.getEntryActions());
            Collection<Function<StateContext<String, String>, Mono<Void>>> exitActions = this.loadStateActionsFromRepositoryState(repositoryState.getExitActions());
            RepositoryState parentState = repositoryState.getParentState();
            String region = repositoryState.getRegion();
            StateData stateData = new StateData((Object)(parentState != null ? parentState.getState() : null), (Object)region, (Object)repositoryState.getState(), repositoryState.isInitial().booleanValue());
            Object var13_15 = null;
            if (repositoryState.getInitialAction() != null) {
                if (StringUtils.hasText((String)repositoryState.getInitialAction().getName())) {
                    Action action = this.resolveAction(repositoryState.getInitialAction().getName());
                } else if (StringUtils.hasText((String)repositoryState.getInitialAction().getSpel())) {
                    SpelExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                    SpelExpressionAction spelExpressionAction = new SpelExpressionAction(parser.parseExpression(repositoryState.getInitialAction().getSpel()));
                }
            }
            stateData.setInitialAction((Action)var13_14);
            stateData.setStateActions(stateActions);
            stateData.setEntryActions(entryActions);
            stateData.setExitActions(exitActions);
            if (repositoryState.getKind() != null) {
                stateData.setPseudoStateKind(repositoryState.getKind());
                if (repositoryState.getKind() == PseudoStateKind.END) {
                    stateData.setEnd(true);
                }
            }
            stateData.setDeferred(repositoryState.getDeferredEvents());
            if (subStateMachineModel != null) {
                ArrayList<StateData> submachineStateData = new ArrayList<StateData>();
                Collection submachineStateDataOrig = subStateMachineModel.getStatesData().getStateData();
                for (StateData sd : submachineStateDataOrig) {
                    submachineStateData.add(new StateData((Object)repositoryState.getState(), sd.getRegion(), (Object)((String)sd.getState()), sd.getDeferred(), sd.getEntryActions(), sd.getExitActions(), sd.isInitial(), sd.getInitialAction()));
                }
                stateData.setSubmachineStateData(submachineStateData);
            }
            stateDatas.add(stateData);
        }
        StatesData statesData = new StatesData(stateDatas);
        ArrayList<TransitionData> arrayList = new ArrayList<TransitionData>();
        ArrayList<EntryData> entrys = new ArrayList<EntryData>();
        ArrayList<ExitData> exits = new ArrayList<ExitData>();
        ArrayList<HistoryData> historys = new ArrayList<HistoryData>();
        HashMap choices = new HashMap();
        HashMap<String, LinkedList<ChoiceData>> junctions = new HashMap<String, LinkedList<ChoiceData>>();
        HashMap forks = new HashMap();
        HashMap<String, LinkedList<ChoiceData>> joins = new HashMap<String, LinkedList<ChoiceData>>();
        for (RepositoryTransition repositoryTransition : this.transitionRepository.findByMachineId(machineId == null ? "" : machineId)) {
            List<Object> list;
            ArrayList<Function> actions = new ArrayList<Function>();
            ArrayList<Action> originalActions = new ArrayList<Action>();
            Set<? extends RepositoryAction> repositoryActions = repositoryTransition.getActions();
            if (repositoryActions != null) {
                for (RepositoryAction repositoryAction : repositoryActions) {
                    Action action = null;
                    if (StringUtils.hasText((String)repositoryAction.getName())) {
                        action = this.resolveAction(repositoryAction.getName());
                    } else if (StringUtils.hasText((String)repositoryAction.getSpel())) {
                        SpelExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                        action = new SpelExpressionAction(parser.parseExpression(repositoryAction.getSpel()));
                    }
                    if (action == null) continue;
                    actions.add(Actions.from((Action)action));
                    originalActions.add(action);
                }
            }
            TransitionKind kind = repositoryTransition.getKind();
            Guard<String, String> guard = this.resolveGuard(repositoryTransition);
            arrayList.add(new TransitionData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState(), (Object)repositoryTransition.getEvent(), actions, Guards.from(guard), kind != null ? kind : TransitionKind.EXTERNAL));
            if (repositoryTransition.getSource().getKind() == PseudoStateKind.ENTRY) {
                entrys.add(new EntryData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState()));
                continue;
            }
            if (repositoryTransition.getSource().getKind() == PseudoStateKind.EXIT) {
                exits.add(new ExitData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState()));
                continue;
            }
            if (repositoryTransition.getSource().getKind() == PseudoStateKind.CHOICE) {
                list = (LinkedList<ChoiceData>)choices.get(repositoryTransition.getSource().getState());
                if (list == null) {
                    list = new LinkedList<ChoiceData>();
                    choices.put(repositoryTransition.getSource().getState(), list);
                }
                if (guard == null) {
                    list.addLast(new ChoiceData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState(), guard, originalActions));
                    continue;
                }
                list.addFirst(new ChoiceData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState(), guard, originalActions));
                continue;
            }
            if (repositoryTransition.getSource().getKind() == PseudoStateKind.JUNCTION) {
                list = (LinkedList)junctions.get(repositoryTransition.getSource().getState());
                if (list == null) {
                    list = new LinkedList();
                    junctions.put(repositoryTransition.getSource().getState(), (LinkedList<ChoiceData>)list);
                }
                if (guard == null) {
                    list.addLast((ChoiceData)new JunctionData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState(), guard, originalActions));
                    continue;
                }
                list.addFirst((ChoiceData)new JunctionData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState(), guard, originalActions));
                continue;
            }
            if (repositoryTransition.getSource().getKind() == PseudoStateKind.FORK) {
                list = (List)forks.get(repositoryTransition.getSource().getState());
                if (list == null) {
                    list = new ArrayList();
                    forks.put(repositoryTransition.getSource().getState(), list);
                }
                list.add((ChoiceData)repositoryTransition.getTarget().getState());
                continue;
            }
            if (repositoryTransition.getTarget().getKind() == PseudoStateKind.JOIN) {
                list = (List)joins.get(repositoryTransition.getTarget().getState());
                if (list == null) {
                    list = new ArrayList();
                    joins.put(repositoryTransition.getTarget().getState(), (LinkedList<ChoiceData>)list);
                }
                list.add((ChoiceData)repositoryTransition.getSource().getState());
                continue;
            }
            if (repositoryTransition.getSource().getKind() == PseudoStateKind.HISTORY_SHALLOW) {
                historys.add(new HistoryData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState()));
                continue;
            }
            if (repositoryTransition.getSource().getKind() != PseudoStateKind.HISTORY_DEEP) continue;
            historys.add(new HistoryData((Object)repositoryTransition.getSource().getState(), (Object)repositoryTransition.getTarget().getState()));
        }
        HashMap choicesCopy = new HashMap();
        choicesCopy.putAll(choices);
        HashMap<String, LinkedList<ChoiceData>> hashMap = new HashMap<String, LinkedList<ChoiceData>>();
        hashMap.putAll(junctions);
        TransitionsData transitionsData = new TransitionsData(arrayList, choicesCopy, hashMap, forks, joins, entrys, exits, historys);
        return new DefaultStateMachineModel(null, statesData, transitionsData);
    }

    private Collection<Function<StateContext<String, String>, Mono<Void>>> loadStateActionsFromRepositoryState(Set<? extends RepositoryAction> repositoryStateActions) {
        ArrayList<Function<StateContext<String, String>, Mono<Void>>> stateActions = new ArrayList<Function<StateContext<String, String>, Mono<Void>>>();
        if (repositoryStateActions != null) {
            for (RepositoryAction repositoryAction : repositoryStateActions) {
                Action action = null;
                if (StringUtils.hasText((String)repositoryAction.getName())) {
                    action = this.resolveAction(repositoryAction.getName());
                } else if (StringUtils.hasText((String)repositoryAction.getSpel())) {
                    SpelExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                    action = new SpelExpressionAction(parser.parseExpression(repositoryAction.getSpel()));
                }
                if (action == null) continue;
                stateActions.add(Actions.from((Action)action));
            }
        }
        return stateActions;
    }

    private Guard<String, String> resolveGuard(RepositoryTransition t) {
        Guard guard = null;
        RepositoryGuard repositoryGuard = t.getGuard();
        if (repositoryGuard != null) {
            if (StringUtils.hasText((String)repositoryGuard.getName())) {
                guard = this.resolveGuard(repositoryGuard.getName());
            } else if (StringUtils.hasText((String)repositoryGuard.getSpel())) {
                SpelExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
                guard = new SpelExpressionGuard(parser.parseExpression(repositoryGuard.getSpel()));
            }
        }
        return guard;
    }
}

