/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.spel;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.PropertyNotFoundException;
import org.springframework.binding.expression.ValueCoercionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringELExpression
implements Expression {
    private org.springframework.expression.Expression expression;
    private Class<?> expectedType;
    private Map expressionVariables;
    private ConversionService conversionService;
    private List<PropertyAccessor> propertyAccessors;

    public SpringELExpression(org.springframework.expression.Expression expression, Map expressionVariables, Class expectedType, ConversionService conversionService, List<PropertyAccessor> propertyAccessors) {
        Assert.notNull((Object)expression, (String)"The SpelExpression is required for evaluation");
        this.expression = expression;
        this.expressionVariables = expressionVariables;
        this.expectedType = expectedType;
        this.conversionService = conversionService;
        this.propertyAccessors = propertyAccessors;
    }

    @Override
    public String getExpressionString() {
        return this.expression.getExpressionString();
    }

    @Override
    public Object getValue(Object rootObject) throws EvaluationException {
        try {
            return this.expression.getValue((EvaluationContext)this.newEvaluationContext(rootObject), this.expectedType);
        }
        catch (SpelEvaluationException e) {
            if (e.getMessageCode().equals((Object)SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE)) {
                throw new PropertyNotFoundException(rootObject.getClass(), this.getExpressionString(), e);
            }
            if (e.getMessageCode().equals((Object)SpelMessage.TYPE_CONVERSION_ERROR)) {
                throw new ValueCoercionException(rootObject.getClass(), this.getExpressionString(), null, this.expectedType, e);
            }
            throw new EvaluationException(rootObject.getClass(), this.expression.getExpressionString(), "An ELException occurred getting the value for expression '" + this.getExpressionString() + "' on context [" + rootObject.getClass() + "]", e);
        }
    }

    @Override
    public Class getValueType(Object rootObject) throws EvaluationException {
        try {
            return this.expression.getValueType((EvaluationContext)this.newEvaluationContext(rootObject));
        }
        catch (SpelEvaluationException e) {
            if (e.getMessageCode().equals((Object)SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE)) {
                throw new PropertyNotFoundException(rootObject.getClass(), this.getExpressionString(), e);
            }
            throw new EvaluationException(rootObject.getClass(), this.getExpressionString(), "An ELException occurred getting the value type for expression '" + this.getExpressionString() + "' on context [" + rootObject.getClass() + "]", e);
        }
    }

    @Override
    public void setValue(Object rootObject, Object value) throws EvaluationException {
        try {
            this.expression.setValue((EvaluationContext)this.newEvaluationContext(rootObject), value);
        }
        catch (SpelEvaluationException e) {
            if (e.getMessageCode().equals((Object)SpelMessage.PROPERTY_OR_FIELD_NOT_WRITABLE)) {
                throw new PropertyNotFoundException(rootObject.getClass(), this.getExpressionString(), e);
            }
            if (e.getMessageCode().equals((Object)SpelMessage.EXCEPTION_DURING_PROPERTY_WRITE)) {
                throw new ValueCoercionException(rootObject.getClass(), this.getExpressionString(), value, this.expectedType, e);
            }
            throw new EvaluationException(rootObject.getClass(), this.getExpressionString(), "An ELException occurred setting the value of expression '" + this.getExpressionString() + "' on context [" + rootObject.getClass() + "] to [" + value + "]", e);
        }
    }

    private StandardEvaluationContext newEvaluationContext(Object rootObject) {
        StandardEvaluationContext context = new StandardEvaluationContext(rootObject);
        context.setVariables(this.getVariableValues(rootObject));
        context.setTypeConverter((TypeConverter)new StandardTypeConverter(this.conversionService));
        context.getPropertyAccessors().addAll(this.propertyAccessors);
        return context;
    }

    private Map<String, Object> getVariableValues(Object rootObject) {
        if (this.expressionVariables == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> variableValues = new HashMap<String, Object>(this.expressionVariables.size());
        for (Map.Entry var : this.expressionVariables.entrySet()) {
            variableValues.put((String)var.getKey(), ((Expression)var.getValue()).getValue(rootObject));
        }
        return variableValues;
    }

    public String toString() {
        return this.getExpressionString();
    }
}

