/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.collection.AbstractCachingMapDecorator;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.binding.method.MethodInvocationException;
import org.springframework.binding.method.MethodKey;
import org.springframework.binding.method.MethodSignature;
import org.springframework.binding.method.Parameter;
import org.springframework.binding.method.Parameters;
import org.springframework.core.style.StylerUtils;

public class MethodInvoker {
    private static final Log logger = LogFactory.getLog(MethodInvoker.class);
    private ConversionService conversionService = new DefaultConversionService();
    private Map<MethodKey, Method> methodCache = new AbstractCachingMapDecorator<MethodKey, Method>(true){

        @Override
        public Method create(MethodKey key) {
            return key.getMethod();
        }
    };

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Object invoke(MethodSignature signature, Object bean, Object argumentSource) throws MethodInvocationException {
        Object argument;
        Parameters parameters = signature.getParameters();
        Object[] arguments = new Object[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = parameters.getParameter(i);
            argument = parameter.evaluateArgument(argumentSource);
            arguments[i] = this.applyTypeConversion(argument, parameter.getType());
        }
        Class[] parameterTypes = parameters.getTypesArray();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] != null || (argument = arguments[i]) == null) continue;
            parameterTypes[i] = argument.getClass();
        }
        MethodKey key = new MethodKey(bean.getClass(), signature.getMethodName(), parameterTypes);
        try {
            Method method = this.methodCache.get(key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking method with signature [" + key + "] with arguments " + StylerUtils.style((Object)arguments) + " on bean [" + bean + "]"));
            }
            Object returnValue = method.invoke(bean, arguments);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoked method with signature [" + key + "] returned value [" + returnValue + "]"));
            }
            return returnValue;
        }
        catch (InvocationTargetException e) {
            throw new MethodInvocationException(signature, arguments, e.getTargetException());
        }
        catch (Exception e) {
            throw new MethodInvocationException(signature, arguments, e);
        }
    }

    protected Object applyTypeConversion(Object value, Class targetType) {
        if (value == null || targetType == null) {
            return value;
        }
        return this.conversionService.getConversionExecutor(value.getClass(), targetType).execute(value);
    }
}

