/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.message;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.collection.AbstractCachingMapDecorator;
import org.springframework.binding.message.Message;
import org.springframework.binding.message.MessageCriteria;
import org.springframework.binding.message.MessageResolver;
import org.springframework.binding.message.Severity;
import org.springframework.binding.message.StateManageableMessageContext;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.core.style.ToStringCreator;

public class DefaultMessageContext
implements StateManageableMessageContext {
    private static final Log logger = LogFactory.getLog(DefaultMessageContext.class);
    private MessageSource messageSource;
    private Map<Object, List<Message>> sourceMessages = new AbstractCachingMapDecorator<Object, List<Message>>(new LinkedHashMap()){

        @Override
        protected List<Message> create(Object source) {
            return new ArrayList<Message>();
        }
    };

    public DefaultMessageContext() {
        this.init(null);
    }

    public DefaultMessageContext(MessageSource messageSource) {
        this.init(messageSource);
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public Message[] getAllMessages() {
        ArrayList<Message> messages = new ArrayList<Message>();
        Iterator<List<Message>> it = this.sourceMessages.values().iterator();
        while (it.hasNext()) {
            messages.addAll(it.next());
        }
        return messages.toArray(new Message[messages.size()]);
    }

    public Message[] getMessagesBySource(Object source) {
        List<Message> messages = this.sourceMessages.get(source);
        return messages.toArray(new Message[messages.size()]);
    }

    public Message[] getMessagesByCriteria(MessageCriteria criteria) {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (List<Message> sourceMessages : this.sourceMessages.values()) {
            for (Message message : sourceMessages) {
                if (!criteria.test(message)) continue;
                messages.add(message);
            }
        }
        return messages.toArray(new Message[messages.size()]);
    }

    public boolean hasErrorMessages() {
        for (List<Message> sourceMessages : this.sourceMessages.values()) {
            for (Message message : sourceMessages) {
                if (message.getSeverity() != Severity.ERROR) continue;
                return true;
            }
        }
        return false;
    }

    public void addMessage(MessageResolver messageResolver) {
        Locale currentLocale = LocaleContextHolder.getLocale();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolving message using " + messageResolver));
        }
        Message message = messageResolver.resolveMessage(this.messageSource, currentLocale);
        List<Message> messages = this.sourceMessages.get(message.getSource());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding resolved message " + message));
        }
        messages.add(message);
    }

    public void clearMessages() {
        this.sourceMessages.clear();
    }

    public Serializable createMessagesMemento() {
        return new LinkedHashMap<Object, List<Message>>(this.sourceMessages);
    }

    public void restoreMessages(Serializable messagesMemento) {
        this.sourceMessages.putAll((Map)((Object)messagesMemento));
    }

    public void setMessageSource(MessageSource messageSource) {
        if (messageSource == null) {
            messageSource = new DefaultTextFallbackMessageSource();
        }
        this.messageSource = messageSource;
    }

    private void init(MessageSource messageSource) {
        this.setMessageSource(messageSource);
        this.sourceMessages.get(null);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("sourceMessages", this.sourceMessages).toString();
    }

    private static class DefaultTextFallbackMessageSource
    extends AbstractMessageSource {
        private DefaultTextFallbackMessageSource() {
        }

        protected MessageFormat resolveCode(String code, Locale locale) {
            return null;
        }
    }
}

