/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.binding.expression.ExpressionVariable;
import org.springframework.binding.expression.ParserContext;

public class FluentParserContext
implements ParserContext {
    private Class<?> evaluationContextType;
    private Class<?> evaluationResultType;
    private List<ExpressionVariable> expressionVariables;
    private boolean template;

    public FluentParserContext() {
        this.init();
    }

    @Override
    public Class<?> getEvaluationContextType() {
        return this.evaluationContextType;
    }

    @Override
    public Class<?> getExpectedEvaluationResultType() {
        return this.evaluationResultType;
    }

    @Override
    public ExpressionVariable[] getExpressionVariables() {
        return this.expressionVariables.toArray(new ExpressionVariable[this.expressionVariables.size()]);
    }

    @Override
    public boolean isTemplate() {
        return this.template;
    }

    public FluentParserContext evaluate(Class<?> contextType) {
        this.evaluationContextType = contextType;
        return this;
    }

    public FluentParserContext expectResult(Class<?> resultType) {
        this.evaluationResultType = resultType;
        return this;
    }

    public FluentParserContext variable(ExpressionVariable variable) {
        this.expressionVariables.add(variable);
        return this;
    }

    public FluentParserContext variables(ExpressionVariable ... variables) {
        this.expressionVariables.addAll(Arrays.asList(variables));
        return this;
    }

    public FluentParserContext template() {
        this.template = true;
        return this;
    }

    private void init() {
        this.expressionVariables = new ArrayList<ExpressionVariable>();
    }
}

