/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.message;

import java.util.Locale;
import org.springframework.binding.message.Message;
import org.springframework.binding.message.MessageResolver;
import org.springframework.binding.message.Severity;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.core.style.ToStringCreator;

public class DefaultMessageResolver
implements MessageResolver,
MessageSourceResolvable {
    private Object source;
    private String[] codes;
    private Severity severity;
    private Object[] args;
    private String defaultText;

    public DefaultMessageResolver(Object source, String[] codes, Severity severity, Object[] args, String defaultText) {
        this.source = source;
        this.codes = codes;
        this.severity = severity;
        this.args = args;
        this.defaultText = defaultText;
    }

    @Override
    public Message resolveMessage(MessageSource messageSource, Locale locale) {
        return new Message(this.source, this.postProcessMessageText(messageSource.getMessage((MessageSourceResolvable)this, locale)), this.severity);
    }

    protected String postProcessMessageText(String text) {
        return text;
    }

    public String[] getCodes() {
        return this.codes;
    }

    public Object[] getArguments() {
        return this.args;
    }

    public String getDefaultMessage() {
        return this.defaultText;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("source", this.source).append("severity", (Object)this.severity).append("codes", (Object)this.codes).append("args", (Object)this.args).append("defaultText", (Object)this.defaultText).toString();
    }
}

