/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.springframework.faces.ui.BaseDojoComponentRenderer;
import org.springframework.faces.ui.HTML;
import org.springframework.faces.ui.RenderAttributeCallback;
import org.springframework.faces.ui.RendererUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ProgressiveCommandButtonRenderer
extends BaseDojoComponentRenderer {
    private static String[] ATTRIBUTES_TO_RENDER;
    private static String INPUT_TAG_NAME;
    private Map attributeCallbacks;
    private RenderAttributeCallback onclickCallback = new RenderAttributeCallback(){

        public void doRender(FacesContext context, ResponseWriter writer, UIComponent component, String attribute, Object attributeValue, String property) throws IOException {
            StringBuffer onclick = new StringBuffer();
            if (attributeValue != null) {
                String originalOnclick = attributeValue.toString().trim();
                if (!originalOnclick.endsWith(";")) {
                    originalOnclick = String.valueOf(originalOnclick) + ";";
                }
                onclick.append(originalOnclick);
            }
            Boolean ajaxEnabled = (Boolean)component.getAttributes().get("ajaxEnabled");
            String processIds = (String)component.getAttributes().get("processIds");
            if (Boolean.TRUE.equals(ajaxEnabled)) {
                if (StringUtils.hasText((String)processIds) && processIds.indexOf(component.getClientId(context)) == -1) {
                    processIds = String.valueOf(component.getClientId(context)) + ", " + processIds;
                } else if (!StringUtils.hasText((String)processIds)) {
                    processIds = component.getClientId(context);
                }
                onclick.append("Spring.remoting.submitForm('" + component.getClientId(context) + "', ");
                onclick.append("'" + RendererUtils.getFormId(context, component) + "', ");
                onclick.append("{processIds: '" + processIds + "'" + ProgressiveCommandButtonRenderer.this.encodeParamsAsObject(context, component) + "}); return false;");
            } else {
                onclick.append(ProgressiveCommandButtonRenderer.this.getOnClickNoAjax(context, component));
            }
            if (onclick.length() > 0) {
                writer.writeAttribute(attribute, (Object)onclick.toString(), property);
            }
        }
    };

    static {
        INPUT_TAG_NAME = "input";
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.addAll(Arrays.asList(HTML.STANDARD_ATTRIBUTES));
        tempList.addAll(Arrays.asList(HTML.BUTTON_ATTRIBUTES));
        tempList.addAll(Arrays.asList(HTML.COMMON_ELEMENT_EVENTS));
        tempList.addAll(Arrays.asList(HTML.KEYBOARD_EVENTS));
        tempList.addAll(Arrays.asList(HTML.MOUSE_EVENTS));
        ATTRIBUTES_TO_RENDER = new String[tempList.size()];
        ListIterator i = tempList.listIterator();
        while (i.hasNext()) {
            ProgressiveCommandButtonRenderer.ATTRIBUTES_TO_RENDER[i.nextIndex()] = (String)i.next();
        }
    }

    protected Map getAttributeCallbacks(UIComponent component) {
        if (this.attributeCallbacks == null) {
            this.attributeCallbacks = new HashMap();
            this.attributeCallbacks.putAll(super.getAttributeCallbacks(component));
            this.attributeCallbacks.put("onclick", this.onclickCallback);
        }
        return this.attributeCallbacks;
    }

    protected String getOnClickNoAjax(FacesContext context, UIComponent component) {
        return "";
    }

    protected String[] getAttributesToRender(UIComponent component) {
        return ATTRIBUTES_TO_RENDER;
    }

    protected String getRenderedTagName(UIComponent component) {
        return INPUT_TAG_NAME;
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context.getExternalContext().getRequestParameterMap().containsKey(component.getClientId(context))) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }

    public boolean getRendersChildren() {
        return false;
    }

    protected String encodeParamsAsObject(FacesContext context, UIComponent component) {
        StringBuffer paramObj = new StringBuffer();
        int i = 0;
        while (i < component.getChildCount()) {
            if (component.getChildren().get(i) instanceof UIParameter) {
                UIParameter param = (UIParameter)component.getChildren().get(i);
                Assert.hasText((String)param.getName(), (String)"UIParameter requires a name when used as a child of a UICommand component");
                paramObj.append(", " + param.getName() + " : '" + param.getValue() + "'");
            }
            ++i;
        }
        return paramObj.toString();
    }
}

