/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.springframework.webflow.execution.RequestContextHolder;

public class JsfUtils {
    public static void notifyAfterListeners(PhaseId phaseId, Lifecycle lifecycle, FacesContext context) {
        PhaseEvent afterPhaseEvent = new PhaseEvent(context, phaseId, lifecycle);
        int i = lifecycle.getPhaseListeners().length - 1;
        while (i >= 0) {
            PhaseListener listener = lifecycle.getPhaseListeners()[i];
            if (listener.getPhaseId() == phaseId || listener.getPhaseId() == PhaseId.ANY_PHASE) {
                listener.afterPhase(afterPhaseEvent);
            }
            --i;
        }
    }

    public static void notifyBeforeListeners(PhaseId phaseId, Lifecycle lifecycle, FacesContext context) {
        PhaseEvent beforePhaseEvent = new PhaseEvent(context, phaseId, lifecycle);
        int i = 0;
        while (i < lifecycle.getPhaseListeners().length) {
            PhaseListener listener = lifecycle.getPhaseListeners()[i];
            if (listener.getPhaseId() == phaseId || listener.getPhaseId() == PhaseId.ANY_PHASE) {
                listener.beforePhase(beforePhaseEvent);
            }
            ++i;
        }
    }

    public static boolean isFlowRequest() {
        return RequestContextHolder.getRequestContext() != null;
    }

    public static boolean isAsynchronousFlowRequest() {
        return JsfUtils.isFlowRequest() && RequestContextHolder.getRequestContext().getExternalContext().isAjaxRequest();
    }
}

