/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.ui;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.springframework.faces.ui.DojoElementDecorationRenderer;
import org.springframework.faces.ui.RendererUtils;
import org.springframework.faces.ui.SpringJavascriptElementDecoration;
import org.springframework.faces.ui.resource.ResourceHelper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AjaxEventInterceptorRenderer
extends DojoElementDecorationRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String event = (String)component.getAttributes().get("event");
        Assert.hasText((String)event, (String)("The event attribute is required on " + component));
        Assert.isTrue((component.getChildCount() == 1 ? 1 : 0) != 0, (String)("Exactly one child component is required for " + component));
        ResourceHelper.beginScriptBlock(context);
        ResponseWriter writer = context.getResponseWriter();
        String processIds = (String)component.getAttributes().get("processIds");
        if (StringUtils.hasText((String)processIds) && processIds.indexOf(component.getClientId(context)) == -1) {
            processIds = component.getClientId(context) + ", " + processIds;
        } else if (!StringUtils.hasText((String)processIds)) {
            processIds = component.getClientId(context);
        }
        String childId = this.getElementId(context, component);
        StringBuffer script = new StringBuffer();
        script.append("dojo.addOnLoad(function(){");
        script.append("Spring.addDecoration(new Spring.AjaxEventDecoration({");
        script.append("event:'" + event + "'");
        script.append(", elementId: '" + childId + "'");
        script.append(", sourceId: '" + component.getClientId(context) + "'");
        script.append(", formId : '" + RendererUtils.getFormId(context, component) + "'");
        script.append(", params: {processIds : '" + processIds + "'");
        script.append(", ajaxSource : '" + component.getClientId(context) + "'} }));});");
        writer.writeText((Object)script.toString(), null);
        ResourceHelper.endScriptBlock(context);
    }

    private String getElementId(FacesContext context, UIComponent component) {
        if (component.getChildCount() > 0) {
            UIComponent child = (UIComponent)component.getChildren().get(0);
            if (!(child instanceof SpringJavascriptElementDecoration)) {
                return child.getClientId(context);
            }
            return this.getElementId(context, child);
        }
        throw new FacesException("Could not locate a proper child element to trigger the ajax event.");
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context.getExternalContext().getRequestParameterMap().containsKey("ajaxSource") && ((String)context.getExternalContext().getRequestParameterMap().get("ajaxSource")).equals(component.getClientId(context))) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }
}

