/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.ui;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.springframework.faces.ui.BaseHtmlTagRenderer;
import org.springframework.faces.ui.RenderAttributeCallback;

public abstract class BaseComponentRenderer
extends BaseHtmlTagRenderer {
    private Map attributeCallbacks;
    private RenderAttributeCallback idCallback = new RenderAttributeCallback(){

        public void doRender(FacesContext context, ResponseWriter writer, UIComponent component, String attribute, Object attributeValue, String property) throws IOException {
            writer.writeAttribute(attribute, (Object)component.getClientId(context), property);
        }
    };
    private RenderAttributeCallback disabledCallback = new RenderAttributeCallback(){

        public void doRender(FacesContext context, ResponseWriter writer, UIComponent component, String attribute, Object attributeValue, String property) throws IOException {
            if (Boolean.TRUE.equals(attributeValue)) {
                writer.writeAttribute(attribute, (Object)"disabled", property);
            }
        }
    };

    protected Map getAttributeCallbacks(UIComponent component) {
        if (this.attributeCallbacks == null) {
            this.attributeCallbacks = new HashMap();
            this.attributeCallbacks.put("id", this.idCallback);
            this.attributeCallbacks.put("name", this.idCallback);
            this.attributeCallbacks.put("disabled", this.disabledCallback);
        }
        return this.attributeCallbacks;
    }
}

