/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.lang.reflect.Constructor;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitWrapper;
import javax.faces.render.ResponseStateManager;
import org.springframework.beans.BeanUtils;
import org.springframework.faces.webflow.FlowResponseStateManager;
import org.springframework.faces.webflow.JsfRuntimeInformation;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.util.ClassUtils;

public class FlowRenderKit
extends RenderKitWrapper {
    private final RenderKit wrapped;
    private final ResponseStateManager flowViewResponseStateManager;

    public FlowRenderKit(RenderKit wrapped) {
        this.wrapped = wrapped;
        this.flowViewResponseStateManager = this.initResponseStateManager(wrapped.getResponseStateManager());
    }

    private ResponseStateManager initResponseStateManager(ResponseStateManager wrapped) {
        Constructor constructor;
        if (!JsfRuntimeInformation.isMyFacesInUse()) {
            return new FlowResponseStateManager(wrapped);
        }
        try {
            String className = "org.springframework.faces.webflow.MyFacesFlowResponseStateManager";
            Class clazz = ClassUtils.forName((String)className, (ClassLoader)FlowRenderKit.class.getClassLoader());
            constructor = ClassUtils.getConstructorIfAvailable((Class)clazz, (Class[])new Class[]{FlowResponseStateManager.class});
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not initialize MyFacesFlowResponseStateManager", e);
        }
        catch (LinkageError e) {
            throw new IllegalStateException("Could not initialize MyFacesFlowResponseStateManager", e);
        }
        return (ResponseStateManager)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{new FlowResponseStateManager(wrapped)});
    }

    public RenderKit getWrapped() {
        return this.wrapped;
    }

    public ResponseStateManager getResponseStateManager() {
        if (JsfUtils.isFlowRequest()) {
            return this.flowViewResponseStateManager;
        }
        return this.wrapped.getResponseStateManager();
    }
}

