/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import javax.faces.application.Application;
import javax.faces.application.ApplicationWrapper;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import org.springframework.faces.webflow.FlowStateManager;
import org.springframework.faces.webflow.FlowViewHandler;
import org.springframework.util.Assert;

public class FlowApplication
extends ApplicationWrapper {
    private final Application wrapped;

    public FlowApplication(Application wrapped) {
        StateManager manager;
        Assert.notNull((Object)wrapped, (String)"The wrapped Application instance must not be null!");
        this.wrapped = wrapped;
        ViewHandler handler = this.wrapped.getViewHandler();
        if (this.shouldWrap(handler)) {
            this.wrapAndSetViewHandler(handler);
        }
        if (this.shouldWrap(manager = this.wrapped.getStateManager())) {
            this.wrapAndSetStateManager(manager);
        }
    }

    public Application getWrapped() {
        return this.wrapped;
    }

    public void setStateManager(StateManager manager) {
        if (this.shouldWrap(manager)) {
            this.wrapAndSetStateManager(manager);
        } else {
            super.setStateManager(manager);
        }
    }

    private boolean shouldWrap(StateManager manager) {
        return manager != null && !(manager instanceof FlowStateManager);
    }

    private void wrapAndSetStateManager(StateManager target) {
        super.setStateManager((StateManager)new FlowStateManager(target));
    }

    public void setViewHandler(ViewHandler handler) {
        if (this.shouldWrap(handler)) {
            this.wrapAndSetViewHandler(handler);
        } else {
            super.setViewHandler(handler);
        }
    }

    private boolean shouldWrap(ViewHandler delegateViewHandler) {
        return delegateViewHandler != null && !(delegateViewHandler instanceof FlowViewHandler);
    }

    private void wrapAndSetViewHandler(ViewHandler target) {
        if (target != null && !(target instanceof FlowViewHandler)) {
            FlowViewHandler handler = new FlowViewHandler(target);
            super.setViewHandler((ViewHandler)handler);
        }
    }
}

