/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.core.collection;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;

public class CollectionUtils {
    public static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    public static final AttributeMap EMPTY_ATTRIBUTE_MAP = new LocalAttributeMap(Collections.EMPTY_MAP);

    private CollectionUtils() {
    }

    public static Iterator toIterator(Enumeration enumeration) {
        return new EnumerationIterator(enumeration);
    }

    public static AttributeMap singleEntryMap(String attributeName, Object attributeValue) {
        return new LocalAttributeMap(attributeName, attributeValue);
    }

    public static boolean addAllNoDuplicates(List target, Object[] objects) {
        if (objects == null || objects.length == 0) {
            return false;
        }
        boolean changed = false;
        int i = 0;
        while (i < objects.length) {
            if (!target.contains(objects[i])) {
                target.add(objects[i]);
                changed = true;
            }
            ++i;
        }
        return changed;
    }

    private static class EmptyIterator
    implements Iterator,
    Serializable {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new UnsupportedOperationException("There are no elements");
        }

        public void remove() {
            throw new UnsupportedOperationException("There are no elements");
        }
    }

    private static class EnumerationIterator
    implements Iterator {
        private Enumeration enumeration;

        public EnumerationIterator(Enumeration enumeration) {
            this.enumeration = enumeration;
        }

        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        public Object next() {
            return this.enumeration.nextElement();
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

