/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression.spel;

import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.RequestContext;

public class ScopeSearchingPropertyAccessor
implements PropertyAccessor {
    public Class[] getSpecificTargetClasses() {
        return new Class[]{RequestContext.class};
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        return this.findScopeForAttribute((RequestContext)target, name) != null;
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        MutableAttributeMap scope = this.findScopeForAttribute((RequestContext)target, name);
        return scope != null ? new TypedValue(scope.get(name)) : null;
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return this.findScopeForAttribute((RequestContext)target, name) != null;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        MutableAttributeMap scope = this.findScopeForAttribute((RequestContext)target, name);
        if (scope != null) {
            scope.put(name, newValue);
        }
    }

    private MutableAttributeMap findScopeForAttribute(RequestContext requestContext, String name) {
        if (requestContext.getRequestScope().contains(name)) {
            return requestContext.getRequestScope();
        }
        if (requestContext.getFlashScope().contains(name)) {
            return requestContext.getFlashScope();
        }
        if (requestContext.inViewState() && requestContext.getViewScope().contains(name)) {
            return requestContext.getViewScope();
        }
        if (requestContext.getFlowScope().contains(name)) {
            return requestContext.getFlowScope();
        }
        if (requestContext.getConversationScope().contains(name)) {
            return requestContext.getConversationScope();
        }
        return null;
    }
}

