/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.LinkedList;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractModel;
import org.springframework.webflow.engine.model.AbstractStateModel;
import org.springframework.webflow.engine.model.Model;
import org.springframework.webflow.engine.model.PersistenceContextModel;
import org.springframework.webflow.engine.model.SecuredModel;

public class FlowModel
extends AbstractModel {
    private String abztract;
    private String parent;
    private String startStateId;
    private LinkedList attributes;
    private SecuredModel secured;
    private PersistenceContextModel persistenceContext;
    private LinkedList vars;
    private LinkedList inputs;
    private LinkedList outputs;
    private LinkedList onStartActions;
    private LinkedList states;
    private LinkedList globalTransitions;
    private LinkedList onEndActions;
    private LinkedList exceptionHandlers;
    private LinkedList beanImports;

    public boolean isMergeableWith(Model model) {
        return model instanceof FlowModel;
    }

    public void merge(Model model) {
        FlowModel flow = (FlowModel)model;
        this.setParent(null);
        this.setStartStateId(this.merge(this.getStartStateId(), flow.getStartStateId()));
        this.setAttributes(this.merge(this.getAttributes(), flow.getAttributes()));
        this.setSecured((SecuredModel)this.merge(this.getSecured(), flow.getSecured()));
        this.setPersistenceContext((PersistenceContextModel)this.merge(this.getPersistenceContext(), flow.getPersistenceContext()));
        this.setVars(this.merge(this.getVars(), flow.getVars(), false));
        this.setInputs(this.merge(this.getInputs(), flow.getInputs()));
        this.setOutputs(this.merge(this.getOutputs(), flow.getOutputs()));
        this.setOnStartActions(this.merge(this.getOnStartActions(), flow.getOnStartActions(), false));
        this.setStates(this.merge(this.getStates(), flow.getStates()));
        this.setGlobalTransitions(this.merge(this.getGlobalTransitions(), flow.getGlobalTransitions()));
        this.setOnEndActions(this.merge(this.getOnEndActions(), flow.getOnEndActions(), false));
        this.setExceptionHandlers(this.merge(this.getExceptionHandlers(), flow.getExceptionHandlers()));
        this.setBeanImports(this.merge(this.getBeanImports(), flow.getBeanImports()));
    }

    public Model createCopy() {
        FlowModel copy = new FlowModel();
        copy.setAbstract(this.abztract);
        copy.setParent(this.parent);
        copy.setStartStateId(this.startStateId);
        copy.setAttributes(this.copyList(this.attributes));
        copy.setSecured((SecuredModel)this.copy(this.secured));
        copy.setPersistenceContext((PersistenceContextModel)this.copy(this.persistenceContext));
        copy.setVars(this.copyList(this.vars));
        copy.setInputs(this.copyList(this.inputs));
        copy.setOutputs(this.copyList(this.outputs));
        copy.setOnStartActions(this.copyList(this.onStartActions));
        copy.setStates(this.copyList(this.states));
        copy.setGlobalTransitions(this.copyList(this.globalTransitions));
        copy.setOnEndActions(this.copyList(this.onEndActions));
        copy.setExceptionHandlers(this.copyList(this.exceptionHandlers));
        copy.setBeanImports(this.copyList(this.beanImports));
        return copy;
    }

    public String getAbstract() {
        return this.abztract;
    }

    public void setAbstract(String abztract) {
        this.abztract = StringUtils.hasText((String)abztract) ? abztract : null;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = StringUtils.hasText((String)parent) ? parent : null;
    }

    public String getStartStateId() {
        return this.startStateId;
    }

    public void setStartStateId(String startStateId) {
        this.startStateId = StringUtils.hasText((String)startStateId) ? startStateId : null;
    }

    public LinkedList getAttributes() {
        return this.attributes;
    }

    public void setAttributes(LinkedList attributes) {
        this.attributes = attributes;
    }

    public SecuredModel getSecured() {
        return this.secured;
    }

    public void setSecured(SecuredModel secured) {
        this.secured = secured;
    }

    public PersistenceContextModel getPersistenceContext() {
        return this.persistenceContext;
    }

    public void setPersistenceContext(PersistenceContextModel persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public LinkedList getVars() {
        return this.vars;
    }

    public void setVars(LinkedList vars) {
        this.vars = vars;
    }

    public LinkedList getInputs() {
        return this.inputs;
    }

    public void setInputs(LinkedList inputs) {
        this.inputs = inputs;
    }

    public LinkedList getOutputs() {
        return this.outputs;
    }

    public void setOutputs(LinkedList outputs) {
        this.outputs = outputs;
    }

    public LinkedList getOnStartActions() {
        return this.onStartActions;
    }

    public void setOnStartActions(LinkedList onStartActions) {
        this.onStartActions = onStartActions;
    }

    public LinkedList getStates() {
        return this.states;
    }

    public AbstractStateModel getStateById(String id) {
        if (this.states != null) {
            for (AbstractStateModel state : this.states) {
                if (!id.equals(state.getId())) continue;
                return state;
            }
        }
        return null;
    }

    public void setStates(LinkedList states) {
        this.states = states;
    }

    public LinkedList getGlobalTransitions() {
        return this.globalTransitions;
    }

    public void setGlobalTransitions(LinkedList globalTransitions) {
        this.globalTransitions = globalTransitions;
    }

    public LinkedList getOnEndActions() {
        return this.onEndActions;
    }

    public void setOnEndActions(LinkedList onEndActions) {
        this.onEndActions = onEndActions;
    }

    public LinkedList getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public void setExceptionHandlers(LinkedList exceptionHandlers) {
        this.exceptionHandlers = exceptionHandlers;
    }

    public LinkedList getBeanImports() {
        return this.beanImports;
    }

    public void setBeanImports(LinkedList beanImports) {
        this.beanImports = beanImports;
    }
}

