/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.conversation.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.webflow.conversation.ConversationLockException;
import org.springframework.webflow.conversation.impl.ConversationLock;
import org.springframework.webflow.conversation.impl.LockInterruptedException;
import org.springframework.webflow.conversation.impl.LockTimeoutException;

public class JdkConcurrentConversationLock
implements ConversationLock {
    private Lock lock = new ReentrantLock();
    private int timeoutSeconds;

    public JdkConcurrentConversationLock(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    @Override
    public void lock() throws ConversationLockException {
        try {
            boolean acquired = this.lock.tryLock(this.timeoutSeconds, TimeUnit.SECONDS);
            if (!acquired) {
                throw new LockTimeoutException(this.timeoutSeconds);
            }
        }
        catch (InterruptedException e) {
            throw new LockInterruptedException(e);
        }
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }
}

