/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.servlet;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.binding.collection.StringKeyedMapAdapter;
import org.springframework.util.Assert;
import org.springframework.util.CompositeIterator;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.webflow.core.collection.CollectionUtils;

public class HttpServletRequestParameterMap
extends StringKeyedMapAdapter<Object> {
    private HttpServletRequest request;

    public HttpServletRequestParameterMap(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"The HTTP servlet request is required");
        this.request = request;
    }

    protected Object getAttribute(String key) {
        MultipartHttpServletRequest multipartRequest;
        List data;
        if (this.request instanceof MultipartHttpServletRequest && (data = (List)(multipartRequest = (MultipartHttpServletRequest)this.request).getMultiFileMap().get((Object)key)) != null && data.size() > 0) {
            if (data.size() == 1) {
                return data.get(0);
            }
            return data;
        }
        String[] parameters = this.request.getParameterValues(key);
        if (parameters == null) {
            return null;
        }
        if (parameters.length == 1) {
            return parameters[0];
        }
        return parameters;
    }

    protected void setAttribute(String key, Object value) {
        throw new UnsupportedOperationException("HttpServletRequest parameter maps are immutable");
    }

    protected void removeAttribute(String key) {
        throw new UnsupportedOperationException("HttpServletRequest parameter maps are immutable");
    }

    protected Iterator<String> getAttributeNames() {
        if (this.request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)this.request;
            CompositeIterator iterator = new CompositeIterator();
            iterator.add(multipartRequest.getFileMap().keySet().iterator());
            iterator.add(this.getRequestParameterNames());
            return iterator;
        }
        return this.getRequestParameterNames();
    }

    private Iterator<String> getRequestParameterNames() {
        return CollectionUtils.toIterator(this.request.getParameterNames());
    }
}

