/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.conversation.impl;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.ConversationParameters;
import org.springframework.webflow.conversation.NoSuchConversationException;
import org.springframework.webflow.conversation.impl.ContainedConversation;
import org.springframework.webflow.conversation.impl.ConversationLock;
import org.springframework.webflow.conversation.impl.SimpleConversationId;

public class ConversationContainer
implements Serializable {
    private static final Log logger = LogFactory.getLog(ConversationContainer.class);
    private int maxConversations;
    private String sessionKey;
    private List<ContainedConversation> conversations;
    private int conversationIdSequence;

    public ConversationContainer(int maxConversations, String sessionKey) {
        this.maxConversations = maxConversations;
        this.sessionKey = sessionKey;
        this.conversations = new CopyOnWriteArrayList<ContainedConversation>();
    }

    String getSessionKey() {
        return this.sessionKey;
    }

    public int size() {
        return this.conversations.size();
    }

    public synchronized Conversation createConversation(ConversationParameters parameters, ConversationLock lock) {
        ContainedConversation conversation = this.createContainedConversation(this.nextId(), lock);
        conversation.putAttribute("name", parameters.getName());
        conversation.putAttribute("caption", parameters.getCaption());
        conversation.putAttribute("description", parameters.getDescription());
        this.conversations.add(conversation);
        if (this.maxExceeded()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The max number of flow executions has been exceeded for the current user. Removing the oldest conversation with id: " + String.valueOf(this.conversations.get(0).getId())));
            }
            this.conversations.get(0).end();
        }
        return conversation;
    }

    protected ConversationId nextId() {
        return new SimpleConversationId(Integer.valueOf(++this.conversationIdSequence));
    }

    public synchronized Conversation getConversation(ConversationId id) throws NoSuchConversationException {
        for (ContainedConversation conversation : this.conversations) {
            if (!conversation.getId().equals(id)) continue;
            return conversation;
        }
        throw new NoSuchConversationException(id);
    }

    protected final List<ContainedConversation> getConversations() {
        return this.conversations;
    }

    public synchronized void removeConversation(ConversationId id) {
        for (ContainedConversation conversation : this.conversations) {
            if (!conversation.getId().equals(id)) continue;
            this.conversations.remove(conversation);
            break;
        }
    }

    private boolean maxExceeded() {
        return this.maxConversations > 0 && this.conversations.size() > this.maxConversations;
    }

    protected ContainedConversation createContainedConversation(ConversationId id, ConversationLock lock) {
        return new ContainedConversation(this, id, lock);
    }
}

