/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.jibx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.util.XMLEventConsumer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.StAXReaderWrapper;
import org.jibx.runtime.impl.StAXWriter;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.oxm.AbstractMarshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.jibx.JibxSystemException;
import org.springframework.oxm.jibx.JibxUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xml.stream.StaxEventContentHandler;
import org.springframework.xml.stream.XmlEventStreamReader;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class JibxMarshaller
extends AbstractMarshaller
implements InitializingBean {
    private Class targetClass;
    private String bindingName;
    private IBindingFactory bindingFactory;
    private static TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private int indent = -1;
    private String encoding = "UTF-8";
    private Boolean standalone;

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setStandalone(Boolean standalone) {
        this.standalone = standalone;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.targetClass, (String)"targetClass is required");
        if (this.logger.isInfoEnabled()) {
            if (StringUtils.hasLength((String)this.bindingName)) {
                this.logger.info((Object)("Configured for target class [" + this.targetClass + "] using binding [" + this.bindingName + "]"));
            } else {
                this.logger.info((Object)("Configured for target class [" + this.targetClass + "]"));
            }
        }
        try {
            this.bindingFactory = StringUtils.hasLength((String)this.bindingName) ? BindingDirectory.getFactory((String)this.bindingName, (Class)this.targetClass) : BindingDirectory.getFactory((Class)this.targetClass);
        }
        catch (JiBXException ex) {
            throw new JibxSystemException((Exception)((Object)ex));
        }
    }

    public boolean supports(Class clazz) {
        Assert.notNull((Object)clazz, (String)"'clazz' must not be null");
        String[] mappedClasses = this.bindingFactory.getMappedClasses();
        String className = clazz.getName();
        for (int i = 0; i < mappedClasses.length; ++i) {
            if (!className.equals(mappedClasses[i])) continue;
            return true;
        }
        return false;
    }

    public XmlMappingException convertJibxException(JiBXException ex, boolean marshalling) {
        return JibxUtils.convertJibxException(ex, marshalling);
    }

    protected void marshalOutputStream(Object graph, OutputStream outputStream) throws XmlMappingException, IOException {
        try {
            IMarshallingContext marshallingContext = this.createMarshallingContext();
            marshallingContext.marshalDocument(graph, this.encoding, this.standalone, outputStream);
        }
        catch (JiBXException ex) {
            throw this.convertJibxException(ex, true);
        }
    }

    protected void marshalWriter(Object graph, Writer writer) throws XmlMappingException, IOException {
        try {
            IMarshallingContext marshallingContext = this.createMarshallingContext();
            marshallingContext.marshalDocument(graph, this.encoding, this.standalone, writer);
        }
        catch (JiBXException ex) {
            throw this.convertJibxException(ex, true);
        }
    }

    protected void marshalXmlStreamWriter(Object graph, XMLStreamWriter streamWriter) throws XmlMappingException {
        try {
            MarshallingContext marshallingContext = (MarshallingContext)this.createMarshallingContext();
            StAXWriter xmlWriter = new StAXWriter(marshallingContext.getNamespaces(), streamWriter);
            marshallingContext.setXmlWriter((IXMLWriter)xmlWriter);
            marshallingContext.marshalDocument(graph);
        }
        catch (JiBXException ex) {
            throw this.convertJibxException(ex, false);
        }
    }

    protected void marshalDomNode(Object graph, Node node) throws XmlMappingException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.marshalOutputStream(graph, os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(new StreamSource(is), new DOMResult(node));
        }
        catch (IOException ex) {
            throw new JibxSystemException(ex);
        }
        catch (TransformerException ex) {
            throw new JibxSystemException(ex);
        }
    }

    protected void marshalSaxHandlers(Object graph, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XmlMappingException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.marshalOutputStream(graph, os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            Transformer transformer = transformerFactory.newTransformer();
            SAXResult saxResult = new SAXResult(contentHandler);
            saxResult.setLexicalHandler(lexicalHandler);
            transformer.transform(new StreamSource(is), saxResult);
        }
        catch (IOException ex) {
            throw new JibxSystemException(ex);
        }
        catch (TransformerException ex) {
            throw new JibxSystemException(ex);
        }
    }

    protected void marshalXmlEventWriter(Object graph, XMLEventWriter eventWriter) {
        StaxEventContentHandler contentHandler = new StaxEventContentHandler((XMLEventConsumer)eventWriter);
        this.marshalSaxHandlers(graph, (ContentHandler)contentHandler, null);
    }

    protected Object unmarshalInputStream(InputStream inputStream) throws XmlMappingException, IOException {
        try {
            IUnmarshallingContext unmarshallingContext = this.createUnmarshallingContext();
            return unmarshallingContext.unmarshalDocument(inputStream, null);
        }
        catch (JiBXException ex) {
            throw this.convertJibxException(ex, false);
        }
    }

    protected Object unmarshalReader(Reader reader) throws XmlMappingException, IOException {
        try {
            IUnmarshallingContext unmarshallingContext = this.createUnmarshallingContext();
            return unmarshallingContext.unmarshalDocument(reader);
        }
        catch (JiBXException ex) {
            throw this.convertJibxException(ex, false);
        }
    }

    protected Object unmarshalXmlStreamReader(XMLStreamReader streamReader) {
        try {
            UnmarshallingContext unmarshallingContext = (UnmarshallingContext)this.createUnmarshallingContext();
            StAXReaderWrapper xmlReader = new StAXReaderWrapper(streamReader, null, true);
            unmarshallingContext.setDocument((IXMLReader)xmlReader);
            return unmarshallingContext.unmarshalElement();
        }
        catch (JiBXException ex) {
            throw this.convertJibxException(ex, false);
        }
    }

    protected Object unmarshalXmlEventReader(XMLEventReader eventReader) {
        try {
            XmlEventStreamReader streamReader = new XmlEventStreamReader(eventReader);
            return this.unmarshalXmlStreamReader((XMLStreamReader)streamReader);
        }
        catch (XMLStreamException ex) {
            throw new JibxSystemException(ex);
        }
    }

    protected Object unmarshalDomNode(Node node) throws XmlMappingException {
        try {
            Transformer transformer = transformerFactory.newTransformer();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(node), new StreamResult(os));
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            return this.unmarshalInputStream(is);
        }
        catch (IOException ex) {
            throw new JibxSystemException(ex);
        }
        catch (TransformerException ex) {
            throw new JibxSystemException(ex);
        }
    }

    protected Object unmarshalSaxReader(XMLReader xmlReader, InputSource inputSource) throws XmlMappingException, IOException {
        try {
            Transformer transformer = transformerFactory.newTransformer();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            transformer.transform(new SAXSource(xmlReader, inputSource), new StreamResult(os));
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            return this.unmarshalInputStream(is);
        }
        catch (IOException ex) {
            throw new JibxSystemException(ex);
        }
        catch (TransformerException ex) {
            throw new JibxSystemException(ex);
        }
    }

    protected IMarshallingContext createMarshallingContext() throws JiBXException {
        IMarshallingContext marshallingContext = this.bindingFactory.createMarshallingContext();
        marshallingContext.setIndent(this.indent);
        return marshallingContext;
    }

    protected IUnmarshallingContext createUnmarshallingContext() throws JiBXException {
        return this.bindingFactory.createUnmarshallingContext();
    }
}

