/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterMatcher;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.DomWriter;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.SaxWriter;
import com.thoughtworks.xstream.io.xml.StaxReader;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.util.XMLEventConsumer;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.oxm.AbstractMarshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.xstream.XStreamUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.xml.stream.StaxEventContentHandler;
import org.springframework.xml.stream.XmlEventStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class XStreamMarshaller
extends AbstractMarshaller {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private XStream xstream = new XStream();
    private String encoding;
    private Class[] supportedClasses;
    private HierarchicalStreamDriver streamDriver;

    public String getEncoding() {
        return this.encoding != null ? this.encoding : DEFAULT_ENCODING;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public XStream getXStream() {
        return this.xstream;
    }

    public void setMode(int mode) {
        this.getXStream().setMode(mode);
    }

    public void setSupportedClasses(Class[] supportedClasses) {
        this.supportedClasses = supportedClasses;
    }

    public void setConverters(ConverterMatcher[] converters) {
        for (int i = 0; i < converters.length; ++i) {
            if (converters[i] instanceof Converter) {
                this.getXStream().registerConverter((Converter)converters[i], i);
                continue;
            }
            if (converters[i] instanceof SingleValueConverter) {
                this.getXStream().registerConverter((SingleValueConverter)converters[i], i);
                continue;
            }
            throw new IllegalArgumentException("Invalid ConverterMatcher [" + converters[i] + "]");
        }
    }

    public void setStreamDriver(HierarchicalStreamDriver streamDriver) {
        this.streamDriver = streamDriver;
    }

    public void setAliases(Map aliases) {
        Iterator iterator = aliases.entrySet().iterator();
        while (iterator.hasNext()) {
            Class type;
            Map.Entry entry = iterator.next();
            if (entry.getValue() instanceof Class) {
                type = (Class)entry.getValue();
            } else {
                ClassEditor editor = new ClassEditor();
                editor.setAsText(String.valueOf(entry.getValue()));
                type = (Class)editor.getValue();
            }
            this.addAlias((String)entry.getKey(), type);
        }
    }

    public void addAlias(String name, Class type) {
        this.getXStream().alias(name, type);
    }

    public void setUseAttributeForTypes(Class[] types) {
        for (int i = 0; i < types.length; ++i) {
            this.getXStream().useAttributeFor(types[i]);
        }
    }

    public void setUseAttributeFor(Map attributes) {
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getKey() instanceof String && entry.getValue() instanceof Class) {
                this.getXStream().useAttributeFor((String)entry.getKey(), (Class)entry.getValue());
                continue;
            }
            if (entry.getKey() instanceof Class && entry.getValue() instanceof String) {
                this.getXStream().useAttributeFor((Class)entry.getKey(), (String)entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Invalid attribute key and value pair. 'useAttributesFor' property takes either a <String, Class> map or a <Class, String> map");
        }
    }

    public boolean supports(Class clazz) {
        if (ObjectUtils.isEmpty((Object[])this.supportedClasses)) {
            return true;
        }
        for (int i = 0; i < this.supportedClasses.length; ++i) {
            if (!this.supportedClasses[i].isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public XmlMappingException convertXStreamException(Exception ex, boolean marshalling) {
        return XStreamUtils.convertXStreamException(ex, marshalling);
    }

    private void marshal(Object graph, HierarchicalStreamWriter streamWriter) {
        try {
            this.getXStream().marshal(graph, streamWriter);
        }
        catch (Exception ex) {
            throw this.convertXStreamException(ex, true);
        }
    }

    protected void marshalDomNode(Object graph, Node node) throws XmlMappingException {
        DomWriter streamWriter;
        if (node instanceof Document) {
            streamWriter = new DomWriter((Document)node);
        } else if (node instanceof Element) {
            streamWriter = new DomWriter((Element)node);
        } else {
            throw new IllegalArgumentException("DOMResult contains neither Document nor Element");
        }
        this.marshal(graph, (HierarchicalStreamWriter)streamWriter);
    }

    protected void marshalXmlEventWriter(Object graph, XMLEventWriter eventWriter) throws XmlMappingException {
        StaxEventContentHandler contentHandler = new StaxEventContentHandler((XMLEventConsumer)eventWriter);
        this.marshalSaxHandlers(graph, (ContentHandler)contentHandler, null);
    }

    protected void marshalXmlStreamWriter(Object graph, XMLStreamWriter streamWriter) throws XmlMappingException {
        try {
            this.marshal(graph, (HierarchicalStreamWriter)new StaxWriter(new QNameMap(), streamWriter));
        }
        catch (XMLStreamException ex) {
            throw this.convertXStreamException(ex, true);
        }
    }

    protected void marshalOutputStream(Object graph, OutputStream outputStream) throws XmlMappingException, IOException {
        this.marshalWriter(graph, new OutputStreamWriter(outputStream, this.getEncoding()));
    }

    protected void marshalSaxHandlers(Object graph, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XmlMappingException {
        SaxWriter saxWriter = new SaxWriter();
        saxWriter.setContentHandler(contentHandler);
        this.marshal(graph, (HierarchicalStreamWriter)saxWriter);
    }

    protected void marshalWriter(Object graph, Writer writer) throws XmlMappingException, IOException {
        if (this.streamDriver != null) {
            this.marshal(graph, this.streamDriver.createWriter(writer));
        } else {
            this.marshal(graph, (HierarchicalStreamWriter)new CompactWriter(writer));
        }
    }

    private Object unmarshal(HierarchicalStreamReader streamReader) {
        try {
            return this.getXStream().unmarshal(streamReader);
        }
        catch (Exception ex) {
            throw this.convertXStreamException(ex, false);
        }
    }

    protected Object unmarshalDomNode(Node node) throws XmlMappingException {
        DomReader streamReader;
        if (node instanceof Document) {
            streamReader = new DomReader((Document)node);
        } else if (node instanceof Element) {
            streamReader = new DomReader((Element)node);
        } else {
            throw new IllegalArgumentException("DOMSource contains neither Document nor Element");
        }
        return this.unmarshal((HierarchicalStreamReader)streamReader);
    }

    protected Object unmarshalXmlEventReader(XMLEventReader eventReader) throws XmlMappingException {
        try {
            XmlEventStreamReader streamReader = new XmlEventStreamReader(eventReader);
            return this.unmarshalXmlStreamReader((XMLStreamReader)streamReader);
        }
        catch (XMLStreamException ex) {
            throw this.convertXStreamException(ex, false);
        }
    }

    protected Object unmarshalXmlStreamReader(XMLStreamReader streamReader) throws XmlMappingException {
        return this.unmarshal((HierarchicalStreamReader)new StaxReader(new QNameMap(), streamReader));
    }

    protected Object unmarshalInputStream(InputStream inputStream) throws XmlMappingException, IOException {
        return this.unmarshalReader(new InputStreamReader(inputStream, this.getEncoding()));
    }

    protected Object unmarshalReader(Reader reader) throws XmlMappingException, IOException {
        if (this.streamDriver != null) {
            return this.unmarshal(this.streamDriver.createReader(reader));
        }
        return this.unmarshal((HierarchicalStreamReader)new XppReader(reader));
    }

    protected Object unmarshalSaxReader(XMLReader xmlReader, InputSource inputSource) throws XmlMappingException, IOException {
        throw new UnsupportedOperationException("XStreamMarshaller does not support unmarshalling using SAX XMLReaders");
    }
}

