/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.jaxb;

import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.ValidationException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.jaxb.JaxbMarshallingFailureException;
import org.springframework.oxm.jaxb.JaxbSystemException;
import org.springframework.oxm.jaxb.JaxbUnmarshallingFailureException;
import org.springframework.oxm.jaxb.JaxbValidationFailureException;
import org.springframework.util.ClassUtils;

public abstract class JaxbUtils {
    public static final int JAXB_1 = 0;
    public static final int JAXB_2 = 1;
    private static final String JAXB_2_CLASS_NAME = "javax.xml.bind.Binder";
    private static int jaxbVersion = 0;

    public static int getJaxbVersion() {
        return jaxbVersion;
    }

    public static int getJaxbVersion(ClassLoader classLoader) {
        try {
            ClassUtils.forName((String)JAXB_2_CLASS_NAME, (ClassLoader)classLoader);
            return 1;
        }
        catch (ClassNotFoundException ex) {
            return 0;
        }
    }

    public static XmlMappingException convertJaxbException(JAXBException ex) {
        if (ex instanceof MarshalException) {
            return new JaxbMarshallingFailureException((MarshalException)ex);
        }
        if (ex instanceof UnmarshalException) {
            return new JaxbUnmarshallingFailureException((UnmarshalException)ex);
        }
        if (ex instanceof ValidationException) {
            return new JaxbValidationFailureException((ValidationException)ex);
        }
        return new JaxbSystemException(ex);
    }

    static {
        try {
            ClassUtils.forName((String)JAXB_2_CLASS_NAME);
            jaxbVersion = 1;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

