/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.support;

import org.springframework.security.AccountExpiredException;
import org.springframework.security.CredentialsExpiredException;
import org.springframework.security.DisabledException;
import org.springframework.security.LockedException;
import org.springframework.security.userdetails.UserDetails;

public abstract class SpringSecurityUtils {
    public static void checkUserValidity(UserDetails user) throws AccountExpiredException, CredentialsExpiredException, DisabledException, LockedException {
        if (!user.isAccountNonLocked()) {
            throw new LockedException("User account is locked", (Object)user);
        }
        if (!user.isEnabled()) {
            throw new DisabledException("User is disabled", (Object)user);
        }
        if (!user.isAccountNonExpired()) {
            throw new AccountExpiredException("User account has expired", (Object)user);
        }
        if (!user.isCredentialsNonExpired()) {
            throw new CredentialsExpiredException("User credentials have expired", (Object)user);
        }
    }
}

