/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.wss4j.callback;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.wss4j.callback.AbstractWsPasswordCallbackHandler;

public class SimplePasswordValidationCallbackHandler
extends AbstractWsPasswordCallbackHandler
implements InitializingBean {
    private Properties users = new Properties();

    public void setUsers(Properties users) {
        this.users = users;
    }

    public void setUsersMap(Map users) {
        Iterator iterator = users.keySet().iterator();
        while (iterator.hasNext()) {
            String username = (String)iterator.next();
            String password = (String)users.get(username);
            this.users.setProperty(username, password);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.users, (String)"users is required");
    }

    protected void handleUsernameToken(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        String identifier = callback.getIdentifier();
        callback.setPassword(this.users.getProperty(identifier));
    }

    protected void handleUsernameTokenUnknown(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        String identifier = callback.getIdentifier();
        String storedPassword = this.users.getProperty(identifier);
        String givenPassword = callback.getPassword();
        if (storedPassword == null || !storedPassword.equals(givenPassword)) {
            throw new WSSecurityException(5);
        }
    }
}

