/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback;

import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.callback.AbstractCallbackHandler;
import org.springframework.ws.soap.security.callback.CleanupCallback;
import org.springframework.ws.soap.security.x509.X509AuthenticationToken;

public class SpringCertificateValidationCallbackHandler
extends AbstractCallbackHandler
implements InitializingBean {
    private AuthenticationManager authenticationManager;
    private boolean ignoreFailure = false;

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager is required");
    }

    @Override
    protected void handleInternal(Callback callback) throws IOException, UnsupportedCallbackException {
        if (callback instanceof CertificateValidationCallback) {
            ((CertificateValidationCallback)callback).setValidator((CertificateValidationCallback.CertificateValidator)new SpringSecurityCertificateValidator());
        } else if (callback instanceof CleanupCallback) {
            SecurityContextHolder.clearContext();
        } else {
            throw new UnsupportedCallbackException(callback);
        }
    }

    private class SpringSecurityCertificateValidator
    implements CertificateValidationCallback.CertificateValidator {
        private SpringSecurityCertificateValidator() {
        }

        public boolean validate(X509Certificate certificate) throws CertificateValidationCallback.CertificateValidationException {
            try {
                Authentication authResult = SpringCertificateValidationCallbackHandler.this.authenticationManager.authenticate((Authentication)new X509AuthenticationToken(certificate));
                if (SpringCertificateValidationCallbackHandler.this.logger.isDebugEnabled()) {
                    SpringCertificateValidationCallbackHandler.this.logger.debug((Object)("Authentication request for certificate with DN [" + certificate.getSubjectX500Principal().getName() + "] successful"));
                }
                SecurityContextHolder.getContext().setAuthentication(authResult);
                return true;
            }
            catch (AuthenticationException failed) {
                if (SpringCertificateValidationCallbackHandler.this.logger.isDebugEnabled()) {
                    SpringCertificateValidationCallbackHandler.this.logger.debug((Object)("Authentication request for certificate with DN [" + certificate.getSubjectX500Principal().getName() + "] failed: " + failed.toString()));
                }
                SecurityContextHolder.clearContext();
                boolean result = SpringCertificateValidationCallbackHandler.this.ignoreFailure;
                return result;
            }
        }
    }
}

