/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.x509;

import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.x509.X509AuthenticationToken;
import org.springframework.ws.soap.security.x509.X509AuthoritiesPopulator;
import org.springframework.ws.soap.security.x509.cache.NullX509UserCache;
import org.springframework.ws.soap.security.x509.cache.X509UserCache;

public class X509AuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
MessageSourceAware {
    private static final Log logger = LogFactory.getLog(X509AuthenticationProvider.class);
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private X509AuthoritiesPopulator x509AuthoritiesPopulator;
    private X509UserCache userCache = new NullX509UserCache();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userCache, (String)"An x509UserCache must be set");
        Assert.notNull((Object)this.x509AuthoritiesPopulator, (String)"An X509AuthoritiesPopulator must be set");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        X509Certificate clientCertificate;
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("X509 authentication request: " + String.valueOf(authentication)));
        }
        if ((clientCertificate = (X509Certificate)authentication.getCredentials()) == null) {
            throw new BadCredentialsException(this.messages.getMessage("X509AuthenticationProvider.certificateNull", "Certificate is null"));
        }
        UserDetails user = this.userCache.getUserFromCache(clientCertificate);
        if (user == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authenticating with certificate " + String.valueOf(clientCertificate)));
            }
            user = this.x509AuthoritiesPopulator.getUserDetails(clientCertificate);
            this.userCache.putUserInCache(clientCertificate, user);
        }
        X509AuthenticationToken result = new X509AuthenticationToken(user, clientCertificate, user.getAuthorities());
        result.setDetails(authentication.getDetails());
        return result;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setX509AuthoritiesPopulator(X509AuthoritiesPopulator x509AuthoritiesPopulator) {
        this.x509AuthoritiesPopulator = x509AuthoritiesPopulator;
    }

    public void setX509UserCache(X509UserCache cache) {
        this.userCache = cache;
    }

    public boolean supports(Class<?> authentication) {
        return X509AuthenticationToken.class.isAssignableFrom(authentication);
    }
}

