/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.xmpp;

import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.support.AbstractStandaloneMessageReceiver;
import org.springframework.ws.transport.xmpp.XmppReceiverConnection;

public class XmppMessageReceiver
extends AbstractStandaloneMessageReceiver {
    public static final String DEFAULT_MESSAGE_ENCODING = "UTF-8";
    private XMPPConnection connection;
    private WebServicePacketListener packetListener;
    private String messageEncoding = "UTF-8";

    public void setConnection(XMPPConnection connection) {
        this.connection = connection;
    }

    protected void onActivate() throws XMPPException {
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
    }

    protected void onStart() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Starting XMPP receiver [" + this.connection.getUser() + "]"));
        }
        this.packetListener = new WebServicePacketListener();
        PacketTypeFilter packetFilter = new PacketTypeFilter(Message.class);
        this.connection.addPacketListener((PacketListener)this.packetListener, (PacketFilter)packetFilter);
    }

    protected void onStop() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stopping XMPP receiver [" + this.connection.getUser() + "]"));
        }
        this.connection.removePacketListener((PacketListener)this.packetListener);
        this.packetListener = null;
    }

    protected void onShutdown() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Shutting down XMPP receiver [" + this.connection.getUser() + "]"));
        }
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
    }

    private class WebServicePacketListener
    implements PacketListener {
        private WebServicePacketListener() {
        }

        public void processPacket(Packet packet) {
            XmppMessageReceiver.this.logger.info((Object)("Received " + packet));
            if (packet instanceof Message) {
                Message message = (Message)packet;
                try {
                    XmppReceiverConnection wsConnection = new XmppReceiverConnection(XmppMessageReceiver.this.connection, message);
                    wsConnection.setMessageEncoding(XmppMessageReceiver.this.messageEncoding);
                    XmppMessageReceiver.this.handleConnection((WebServiceConnection)wsConnection);
                }
                catch (Exception ex) {
                    XmppMessageReceiver.this.logger.error((Object)ex);
                }
            }
        }
    }
}

