/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.mail.monitor;

import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.event.MessageCountAdapter;
import jakarta.mail.event.MessageCountEvent;
import jakarta.mail.event.MessageCountListener;
import org.eclipse.angus.mail.imap.IMAPFolder;
import org.springframework.util.Assert;
import org.springframework.ws.transport.mail.monitor.AbstractMonitoringStrategy;

public class ImapIdleMonitoringStrategy
extends AbstractMonitoringStrategy {
    private MessageCountListener messageCountListener;

    @Override
    protected void waitForNewMessages(Folder folder) throws MessagingException, InterruptedException {
        Assert.isInstanceOf(IMAPFolder.class, (Object)folder);
        IMAPFolder imapFolder = (IMAPFolder)folder;
        if (this.searchForNewMessages(folder).length > 0) {
            return;
        }
        if (this.messageCountListener == null) {
            this.createMessageCountListener();
        }
        folder.addMessageCountListener(this.messageCountListener);
        try {
            imapFolder.idle();
        }
        finally {
            folder.removeMessageCountListener(this.messageCountListener);
        }
    }

    private void createMessageCountListener() {
        this.messageCountListener = new MessageCountAdapter(){

            public void messagesAdded(MessageCountEvent e) {
                Message[] messages;
                for (Message message : messages = e.getMessages()) {
                    try {
                        message.getLineCount();
                    }
                    catch (MessagingException messagingException) {
                        // empty catch block
                    }
                }
            }
        };
    }
}

