/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.jms.support.JmsUtils;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractSenderConnection;
import org.springframework.ws.transport.jms.BytesMessageInputStream;
import org.springframework.ws.transport.jms.BytesMessageOutputStream;
import org.springframework.ws.transport.jms.JmsTransportException;
import org.springframework.ws.transport.jms.TextMessageInputStream;
import org.springframework.ws.transport.jms.TextMessageOutputStream;
import org.springframework.ws.transport.jms.support.JmsTransportUtils;

public class JmsSenderConnection
extends AbstractSenderConnection {
    private final ConnectionFactory connectionFactory;
    private final Connection connection;
    private final Session session;
    private final Destination requestDestination;
    private Message requestMessage;
    private @Nullable Destination responseDestination;
    private @Nullable Message responseMessage;
    private long receiveTimeout;
    private int deliveryMode;
    private long timeToLive;
    private int priority;
    private @Nullable String textMessageEncoding;
    private @Nullable MessagePostProcessor postProcessor;
    private boolean sessionTransacted = false;
    private boolean temporaryResponseQueueCreated = false;

    protected JmsSenderConnection(ConnectionFactory connectionFactory, Connection connection, Session session, Destination requestDestination, Message requestMessage) throws JMSException {
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        Assert.notNull((Object)connection, (String)"'connection' must not be null");
        Assert.notNull((Object)session, (String)"'session' must not be null");
        Assert.notNull((Object)requestDestination, (String)"'requestDestination' must not be null");
        Assert.notNull((Object)requestMessage, (String)"'requestMessage' must not be null");
        this.connectionFactory = connectionFactory;
        this.connection = connection;
        this.session = session;
        this.requestDestination = requestDestination;
        this.requestMessage = requestMessage;
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public @Nullable Message getResponseMessage() {
        return this.responseMessage;
    }

    void setResponseDestination(@Nullable Destination responseDestination) {
        this.responseDestination = responseDestination;
    }

    void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    void setPriority(int priority) {
        this.priority = priority;
    }

    void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    void setTextMessageEncoding(String textMessageEncoding) {
        this.textMessageEncoding = textMessageEncoding;
    }

    void setPostProcessor(@Nullable MessagePostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    void setSessionTransacted(boolean sessionTransacted) {
        this.sessionTransacted = sessionTransacted;
    }

    public @Nullable URI getUri() throws URISyntaxException {
        try {
            return JmsTransportUtils.toUri(this.requestDestination);
        }
        catch (JMSException ex) {
            throw new URISyntaxException("", ex.getMessage());
        }
    }

    public boolean hasError() throws IOException {
        return false;
    }

    public @Nullable String getErrorMessage() throws IOException {
        return null;
    }

    public void addRequestHeader(String name, String value) throws IOException {
        try {
            JmsTransportUtils.addHeader(this.requestMessage, name, value);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not set property", ex);
        }
    }

    protected OutputStream getRequestOutputStream() throws IOException {
        if (this.requestMessage instanceof BytesMessage) {
            return new BytesMessageOutputStream((BytesMessage)this.requestMessage);
        }
        if (this.requestMessage instanceof TextMessage) {
            Assert.notNull((Object)this.textMessageEncoding, (String)"MessageEncoding for TextMessage is required");
            return new TextMessageOutputStream((TextMessage)this.requestMessage, this.textMessageEncoding);
        }
        throw new IllegalStateException("Unknown request message type [" + String.valueOf(this.requestMessage) + "]");
    }

    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        MessageProducer messageProducer = null;
        try {
            messageProducer = this.session.createProducer(this.requestDestination);
            messageProducer.setDeliveryMode(this.deliveryMode);
            messageProducer.setTimeToLive(this.timeToLive);
            messageProducer.setPriority(this.priority);
            if (this.responseDestination == null) {
                this.responseDestination = this.session.createTemporaryQueue();
                this.temporaryResponseQueueCreated = true;
            }
            this.requestMessage.setJMSReplyTo(this.responseDestination);
            if (this.postProcessor != null) {
                this.requestMessage = this.postProcessor.postProcessMessage(this.requestMessage);
            }
            this.connection.start();
            messageProducer.send(this.requestMessage);
            if (this.session.getTransacted() && this.isSessionLocallyTransacted(this.session)) {
                JmsUtils.commitIfNecessary((Session)this.session);
            }
        }
        catch (JMSException ex) {
            try {
                throw new JmsTransportException(ex);
            }
            catch (Throwable throwable) {
                JmsUtils.closeMessageProducer(messageProducer);
                throw throwable;
            }
        }
        JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
    }

    private boolean isSessionLocallyTransacted(Session session) {
        return this.sessionTransacted && !ConnectionFactoryUtils.isSessionTransactional((Session)session, (ConnectionFactory)this.connectionFactory);
    }

    protected void onReceiveBeforeRead() throws IOException {
        Destination destination;
        MessageConsumer messageConsumer;
        block13: {
            messageConsumer = null;
            try {
                Message message;
                if (this.temporaryResponseQueueCreated) {
                    messageConsumer = this.session.createConsumer(this.responseDestination);
                } else {
                    String messageId = this.requestMessage.getJMSMessageID().replaceAll("'", "''");
                    String messageSelector = "JMSCorrelationID = '" + messageId + "'";
                    messageConsumer = this.session.createConsumer(this.responseDestination, messageSelector);
                }
                Message message2 = message = this.receiveTimeout >= 0L ? messageConsumer.receive(this.receiveTimeout) : messageConsumer.receive();
                if (message instanceof BytesMessage || message instanceof TextMessage) {
                    this.responseMessage = message;
                    break block13;
                }
                if (message == null) break block13;
                throw new IllegalArgumentException("Wrong message type: [" + String.valueOf(message.getClass()) + "]. Only BytesMessages or TextMessages can be handled.");
            }
            catch (JMSException ex) {
                try {
                    throw new JmsTransportException(ex);
                }
                catch (Throwable throwable) {
                    Destination destination2;
                    JmsUtils.closeMessageConsumer(messageConsumer);
                    if (this.temporaryResponseQueueCreated && (destination2 = this.responseDestination) instanceof TemporaryQueue) {
                        TemporaryQueue temporaryQueue = (TemporaryQueue)destination2;
                        try {
                            temporaryQueue.delete();
                        }
                        catch (JMSException jMSException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        JmsUtils.closeMessageConsumer((MessageConsumer)messageConsumer);
        if (this.temporaryResponseQueueCreated && (destination = this.responseDestination) instanceof TemporaryQueue) {
            TemporaryQueue temporaryQueue = (TemporaryQueue)destination;
            try {
                temporaryQueue.delete();
            }
            catch (JMSException jMSException) {}
        }
    }

    protected boolean hasResponse() throws IOException {
        return this.responseMessage != null;
    }

    public Iterator<String> getResponseHeaderNames() throws IOException {
        try {
            Assert.state((this.responseMessage != null ? 1 : 0) != 0, (String)"ResponseMessage is required");
            return JmsTransportUtils.getHeaderNames(this.responseMessage);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not get property names", ex);
        }
    }

    public Iterator<String> getResponseHeaders(String name) throws IOException {
        try {
            Assert.state((this.responseMessage != null ? 1 : 0) != 0, (String)"ResponseMessage is required");
            return JmsTransportUtils.getHeaders(this.responseMessage, name);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not get property value", ex);
        }
    }

    protected InputStream getResponseInputStream() throws IOException {
        if (this.responseMessage instanceof BytesMessage) {
            return new BytesMessageInputStream((BytesMessage)this.responseMessage);
        }
        if (this.responseMessage instanceof TextMessage) {
            Assert.notNull((Object)this.textMessageEncoding, (String)"MessageEncoding for TextMessage is required");
            return new TextMessageInputStream((TextMessage)this.responseMessage, this.textMessageEncoding);
        }
        throw new IllegalStateException("Unknown response message type [" + String.valueOf(this.responseMessage) + "]");
    }

    protected void onClose() throws IOException {
        JmsUtils.closeSession((Session)this.session);
        ConnectionFactoryUtils.releaseConnection((Connection)this.connection, (ConnectionFactory)this.connectionFactory, (boolean)true);
    }
}

