/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.xmpp;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.support.AbstractStandaloneMessageReceiver;
import org.springframework.ws.transport.xmpp.XmppReceiverConnection;

public class XmppMessageReceiver
extends AbstractStandaloneMessageReceiver {
    public static final String DEFAULT_MESSAGE_ENCODING = "UTF-8";
    private @Nullable XMPPTCPConnection connection;
    private @Nullable WebServicePacketListener packetListener;
    private final String messageEncoding = "UTF-8";

    public void setConnection(XMPPTCPConnection connection) {
        this.connection = connection;
    }

    private XMPPTCPConnection getConnection() {
        Assert.state((this.connection != null ? 1 : 0) != 0, (String)"Connection is required");
        return this.connection;
    }

    protected void onActivate() throws XMPPException, IOException, SmackException {
        if (!this.getConnection().isConnected()) {
            try {
                this.getConnection().connect();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }
    }

    protected void onStart() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Starting XMPP receiver [" + String.valueOf(this.getConnection().getUser()) + "]"));
        }
        this.packetListener = new WebServicePacketListener();
        StanzaTypeFilter packetFilter = new StanzaTypeFilter(Message.class);
        this.getConnection().addAsyncStanzaListener((StanzaListener)this.packetListener, (StanzaFilter)packetFilter);
    }

    protected void onStop() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Stopping XMPP receiver [" + String.valueOf(this.getConnection().getUser()) + "]"));
        }
        this.getConnection().removeAsyncStanzaListener((StanzaListener)this.packetListener);
        this.packetListener = null;
    }

    protected void onShutdown() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Shutting down XMPP receiver [" + String.valueOf(this.getConnection().getUser()) + "]"));
        }
        if (this.getConnection().isConnected()) {
            this.getConnection().disconnect();
        }
    }

    private final class WebServicePacketListener
    implements StanzaListener {
        private WebServicePacketListener() {
        }

        public void processStanza(Stanza packet) {
            XmppMessageReceiver.this.logger.info((Object)("Received " + String.valueOf(packet)));
            if (packet instanceof Message) {
                Message message = (Message)packet;
                try {
                    XmppReceiverConnection wsConnection = new XmppReceiverConnection((XMPPConnection)XmppMessageReceiver.this.getConnection(), message);
                    wsConnection.setMessageEncoding(XmppMessageReceiver.this.messageEncoding);
                    XmppMessageReceiver.this.handleConnection((WebServiceConnection)wsConnection);
                }
                catch (Exception ex) {
                    XmppMessageReceiver.this.logger.error((Object)ex);
                }
            }
        }
    }
}

