/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.support.matcher;

import java.io.IOException;
import java.util.Arrays;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.test.support.AssertionErrors;
import org.springframework.ws.test.support.matcher.WebServiceMessageMatcher;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;

public class SchemaValidatingMatcher
implements WebServiceMessageMatcher {
    private final XmlValidator xmlValidator;

    public SchemaValidatingMatcher(Resource schema, Resource ... furtherSchemas) throws IOException {
        Assert.notNull((Object)schema, (String)"'schema' must not be null");
        Resource[] joinedSchemas = new Resource[furtherSchemas.length + 1];
        joinedSchemas[0] = schema;
        System.arraycopy(furtherSchemas, 0, joinedSchemas, 1, furtherSchemas.length);
        this.xmlValidator = XmlValidatorFactory.createValidator((Resource[])joinedSchemas, (String)"http://www.w3.org/2001/XMLSchema");
    }

    public void match(WebServiceMessage message) throws IOException, AssertionError {
        Object[] exceptions = this.xmlValidator.validate(message.getPayloadSource());
        if (!ObjectUtils.isEmpty((Object[])exceptions)) {
            AssertionErrors.fail("XML is not valid: " + Arrays.toString(exceptions), "Payload", message.getPayloadSource());
        }
    }
}

