/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint;

import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.AbstractMarshallingPayloadEndpoint;

public abstract class AbstractValidatingMarshallingPayloadEndpoint
extends AbstractMarshallingPayloadEndpoint {
    public static final String DEFAULT_REQUEST_NAME = "request";
    private String requestName = "request";
    private Validator[] validators;

    public final String getRequestName() {
        return this.requestName;
    }

    public final void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public final Validator getValidator() {
        return this.validators != null && this.validators.length > 0 ? this.validators[0] : null;
    }

    public final void setValidator(Validator validator) {
        this.validators = new Validator[]{validator};
    }

    public final Validator[] getValidators() {
        return this.validators;
    }

    public final void setValidators(Validator[] validators) {
        this.validators = validators;
    }

    protected final boolean onUnmarshalRequest(MessageContext messageContext, Object requestObject) throws Exception {
        if (this.validators != null) {
            BindException errors = new BindException(requestObject, this.getRequestName());
            for (int i = 0; i < this.validators.length; ++i) {
                ValidationUtils.invokeValidator((Validator)this.validators[i], (Object)requestObject, (Errors)errors);
            }
            if (errors.hasErrors()) {
                return this.onValidationErrors(messageContext, requestObject, (Errors)errors);
            }
        }
        return true;
    }

    protected abstract boolean onValidationErrors(MessageContext var1, Object var2, Errors var3);
}

