/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.JdkVersion;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MethodEndpoint;
import org.springframework.ws.server.endpoint.mapping.AbstractEndpointMapping;

public abstract class AbstractMethodEndpointMapping
extends AbstractEndpointMapping {
    private final Map endpointMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;

    protected Object getEndpointInternal(MessageContext messageContext) throws Exception {
        String key = this.getLookupKeyForMessage(messageContext);
        if (!StringUtils.hasLength((String)key)) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up endpoint for [" + key + "]"));
        }
        return this.lookupEndpoint(key);
    }

    protected abstract String getLookupKeyForMessage(MessageContext var1) throws Exception;

    protected MethodEndpoint lookupEndpoint(String key) {
        return (MethodEndpoint)this.endpointMap.get(key);
    }

    protected void registerEndpoint(String key, MethodEndpoint endpoint) throws BeansException {
        Object mappedEndpoint = this.endpointMap.get(key);
        if (mappedEndpoint != null) {
            throw new ApplicationContextException("Cannot map endpoint [" + endpoint + "] on registration key [" + key + "]: there's already endpoint [" + mappedEndpoint + "] mapped");
        }
        if (endpoint == null) {
            throw new ApplicationContextException("Could not find endpoint for key [" + key + "]");
        }
        this.endpointMap.put(key, endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Mapped key [" + key + "] onto endpoint [" + endpoint + "]"));
        }
    }

    protected void registerMethods(Object endpoint) {
        Assert.notNull((Object)endpoint, (String)"'endpoint' must not be null");
        Method[] methods = this.getEndpointClass(endpoint).getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String key;
            if (JdkVersion.isAtLeastJava15() && methods[i].isSynthetic() || methods[i].getDeclaringClass().equals(class$java$lang$Object == null ? AbstractMethodEndpointMapping.class$("java.lang.Object") : class$java$lang$Object) || !StringUtils.hasLength((String)(key = this.getLookupKeyForMethod(methods[i])))) continue;
            this.registerEndpoint(key, new MethodEndpoint(endpoint, methods[i]));
        }
    }

    protected String getLookupKeyForMethod(Method method) {
        return null;
    }

    protected Class getEndpointClass(Object endpoint) {
        return AopUtils.getTargetClass((Object)endpoint);
    }
}

