/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.server;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.server.endpoint.MethodEndpoint;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.server.AbstractActionMethodEndpointMapping;
import org.springframework.ws.soap.addressing.server.annotation.Action;
import org.springframework.ws.soap.addressing.server.annotation.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationActionEndpointMapping
extends AbstractActionMethodEndpointMapping
implements BeanPostProcessor {
    protected Class<? extends Annotation> getEndpointAnnotationType() {
        return Endpoint.class;
    }

    @Override
    protected URI getActionForMethod(Method method) {
        Action action = method.getAnnotation(Action.class);
        if (action != null && StringUtils.hasText((String)action.value())) {
            try {
                return new URI(action.value());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid Action annotation [" + action.value() + "] on [" + method + "]");
            }
        }
        return null;
    }

    @Override
    protected URI getEndpointAddress(Object endpoint) {
        MethodEndpoint methodEndpoint = (MethodEndpoint)endpoint;
        Class<?> endpointClass = methodEndpoint.getMethod().getDeclaringClass();
        Address address = (Address)AnnotationUtils.findAnnotation(endpointClass, Address.class);
        if (address != null && StringUtils.hasText((String)address.value())) {
            try {
                return new URI(address.value());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid Address annotation [" + address.value() + "] on [" + endpointClass + "]");
            }
        }
        return null;
    }

    @Override
    protected URI getResponseAction(Object endpoint, MessageAddressingProperties map) {
        MethodEndpoint methodEndpoint = (MethodEndpoint)endpoint;
        Action action = methodEndpoint.getMethod().getAnnotation(Action.class);
        if (action != null && StringUtils.hasText((String)action.output())) {
            try {
                return new URI(action.output());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid Action annotation [" + action.value() + "] on [" + methodEndpoint + "]");
            }
        }
        return super.getResponseAction(endpoint, map);
    }

    public final Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public final Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (AopUtils.getTargetClass((Object)bean).getAnnotation(this.getEndpointAnnotationType()) != null) {
            this.registerMethods(bean);
        }
        return bean;
    }
}

