/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.wss4j.callback;

import java.io.IOException;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.callback.CleanupCallback;
import org.springframework.ws.soap.security.wss4j.callback.AbstractWsPasswordCallbackHandler;

public class SpringPlainTextPasswordValidationCallbackHandler
extends AbstractWsPasswordCallbackHandler
implements InitializingBean {
    private AuthenticationManager authenticationManager;
    private boolean ignoreFailure = false;

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager is required");
    }

    protected void handleCleanup(CleanupCallback callback) throws IOException, UnsupportedCallbackException {
        SecurityContextHolder.clearContext();
    }

    protected void handleUsernameTokenUnknown(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        block4: {
            String identifier = callback.getIdentifier();
            try {
                Authentication authResult = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)identifier, (Object)callback.getPassword()));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Authentication success: " + authResult.toString()));
                }
                SecurityContextHolder.getContext().setAuthentication(authResult);
            }
            catch (AuthenticationException failed) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Authentication request for user '" + identifier + "' failed: " + failed.toString()));
                }
                SecurityContextHolder.clearContext();
                if (this.ignoreFailure) break block4;
                throw new WSSecurityException(5, null, null, (Throwable)failed);
            }
        }
    }
}

