/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.transport.http.HttpUrlConnectionMessageSender;
import org.springframework.ws.transport.http.HttpsTransportException;

public class HttpsUrlConnectionMessageSender
extends HttpUrlConnectionMessageSender
implements InitializingBean {
    public static final String DEFAULT_SSL_PROTOCOL = "ssl";
    private String sslProtocol = "ssl";
    private String sslProvider;
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    private HostnameVerifier hostnameVerifier;
    private SecureRandom rnd;

    public void setSslProtocol(String sslProtocol) {
        Assert.hasLength((String)sslProtocol, (String)"'sslProtocol' must not be empty");
        this.sslProtocol = sslProtocol;
    }

    public void setSslProvider(String sslProvider) {
        this.sslProvider = sslProvider;
    }

    public void setKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
    }

    public void setTrustManagers(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setSecureRandom(SecureRandom rnd) {
        this.rnd = rnd;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((!ObjectUtils.isEmpty((Object[])this.keyManagers) || !ObjectUtils.isEmpty((Object[])this.trustManagers) ? 1 : 0) != 0, (String)"Setting either 'keyManagers' or 'trustManagers' is required");
    }

    protected void prepareConnection(HttpURLConnection connection) throws IOException {
        super.prepareConnection(connection);
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            try {
                SSLContext sslContext = this.createSslContext(this.sslProtocol, this.sslProvider);
                sslContext.init(this.keyManagers, this.trustManagers, this.rnd);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Initialized SSL Context with key managers [" + StringUtils.arrayToCommaDelimitedString((Object[])this.keyManagers) + "] trust managers [" + StringUtils.arrayToCommaDelimitedString((Object[])this.trustManagers) + "] secure random [" + this.rnd + "]"));
                }
                httpsConnection.setSSLSocketFactory(sslContext.getSocketFactory());
                if (this.hostnameVerifier != null) {
                    httpsConnection.setHostnameVerifier(this.hostnameVerifier);
                }
            }
            catch (NoSuchProviderException ex) {
                throw new HttpsTransportException("Could not create SSLContext: " + ex.getMessage(), ex);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new HttpsTransportException("Could not create SSLContext: " + ex.getMessage(), ex);
            }
            catch (KeyManagementException ex) {
                throw new HttpsTransportException("Could not initialize SSLContext: " + ex.getMessage(), ex);
            }
        }
    }

    private SSLContext createSslContext(String protocol, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (!StringUtils.hasLength((String)provider)) {
            return SSLContext.getInstance(protocol);
        }
        return SSLContext.getInstance(protocol, provider);
    }
}

