/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.namespace;

import javax.xml.namespace.QName;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Node;

public abstract class QNameUtils {
    private static boolean qNameHasPrefix;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$xml$namespace$QName;

    public static QName createQName(String namespaceUri, String localPart, String prefix) {
        if (qNameHasPrefix) {
            return new QName(namespaceUri, localPart, prefix);
        }
        return new QName(namespaceUri, localPart);
    }

    public static String getPrefix(QName qName) {
        return qNameHasPrefix ? qName.getPrefix() : "";
    }

    public static boolean validateQName(String text) {
        int i;
        if (!StringUtils.hasLength((String)text)) {
            return false;
        }
        return text.charAt(0) != '{' || (i = text.indexOf(125)) != -1 && i != text.length() - 1;
    }

    public static QName getQNameForNode(Node node) {
        if (node.getNamespaceURI() != null && node.getPrefix() != null && node.getLocalName() != null) {
            return QNameUtils.createQName(node.getNamespaceURI(), node.getLocalName(), node.getPrefix());
        }
        if (node.getNamespaceURI() != null && node.getLocalName() != null) {
            return new QName(node.getNamespaceURI(), node.getLocalName());
        }
        if (node.getLocalName() != null) {
            return new QName(node.getLocalName());
        }
        return new QName(node.getNodeName());
    }

    public static String toQualifiedName(QName qName) {
        String prefix = QNameUtils.getPrefix(qName);
        if (!StringUtils.hasLength((String)prefix)) {
            return qName.getLocalPart();
        }
        return prefix + ":" + qName.getLocalPart();
    }

    public static QName toQName(String namespaceUri, String qualifiedName) {
        int idx = qualifiedName.indexOf(58);
        if (idx == -1) {
            return new QName(namespaceUri, qualifiedName);
        }
        return QNameUtils.createQName(namespaceUri, qualifiedName.substring(idx + 1), qualifiedName.substring(0, idx));
    }

    public static QName parseQNameString(String qNameString) {
        Assert.hasLength((String)qNameString, (String)"QName text may not be null or empty");
        if (qNameString.charAt(0) != '{') {
            return new QName(qNameString);
        }
        int endOfNamespaceURI = qNameString.indexOf(125);
        if (endOfNamespaceURI == -1) {
            throw new IllegalArgumentException("Cannot create QName from \"" + qNameString + "\", missing closing \"}\"");
        }
        int prefixSeperator = qNameString.indexOf(58, endOfNamespaceURI + 1);
        String namespaceURI = qNameString.substring(1, endOfNamespaceURI);
        if (prefixSeperator == -1) {
            return new QName(namespaceURI, qNameString.substring(endOfNamespaceURI + 1));
        }
        return QNameUtils.createQName(namespaceURI, qNameString.substring(prefixSeperator + 1), qNameString.substring(endOfNamespaceURI + 1, prefixSeperator));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            (class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = QNameUtils.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName).getDeclaredConstructor(class$java$lang$String == null ? (class$java$lang$String = QNameUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = QNameUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = QNameUtils.class$("java.lang.String")) : class$java$lang$String);
            qNameHasPrefix = true;
        }
        catch (NoSuchMethodException e) {
            qNameHasPrefix = false;
        }
    }
}

