/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.stream;

import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.NotationDeclaration;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.stream.AbstractStaxXmlReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class StaxEventXmlReader
extends AbstractStaxXmlReader {
    private final XMLEventReader reader;

    public StaxEventXmlReader(XMLEventReader reader) {
        try {
            XMLEvent event = reader.peek();
            if (event == null || !event.isStartDocument() && !event.isStartElement()) {
                throw new IllegalStateException("XMLEventReader not at start of document or element");
            }
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException("Could not read first element: " + ex.getMessage());
        }
        this.reader = reader;
    }

    protected void parseInternal() throws SAXException, XMLStreamException {
        boolean documentStarted = false;
        boolean documentEnded = false;
        int elementDepth = 0;
        XMLEvent event = null;
        while (this.reader.hasNext() && elementDepth >= 0) {
            event = this.reader.nextEvent();
            if (!(event.isStartDocument() || event.isEndDocument() || documentStarted)) {
                this.handleStartDocument();
                documentStarted = true;
            }
            switch (event.getEventType()) {
                case 1: {
                    ++elementDepth;
                    this.handleStartElement(event.asStartElement());
                    break;
                }
                case 2: {
                    if (--elementDepth < 0) break;
                    this.handleEndElement(event.asEndElement());
                    break;
                }
                case 3: {
                    this.handleProcessingInstruction((ProcessingInstruction)event);
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.handleCharacters(event.asCharacters());
                    break;
                }
                case 7: {
                    this.setLocator(event.getLocation());
                    this.handleStartDocument();
                    documentStarted = true;
                    break;
                }
                case 8: {
                    this.handleEndDocument();
                    documentEnded = true;
                    break;
                }
                case 14: {
                    this.handleNotationDeclaration((NotationDeclaration)event);
                    break;
                }
                case 15: {
                    this.handleEntityDeclaration((EntityDeclaration)event);
                }
            }
        }
        if (!documentEnded) {
            this.handleEndDocument();
        }
    }

    private void handleCharacters(Characters characters) throws SAXException {
        if (this.getContentHandler() != null) {
            if (characters.isIgnorableWhiteSpace()) {
                this.getContentHandler().ignorableWhitespace(characters.getData().toCharArray(), 0, characters.getData().length());
            } else {
                this.getContentHandler().characters(characters.getData().toCharArray(), 0, characters.getData().length());
            }
        }
    }

    private void handleEndDocument() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().endDocument();
        }
    }

    private void handleEndElement(EndElement endElement) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().endElement(endElement.getName().getNamespaceURI(), endElement.getName().getLocalPart(), QNameUtils.toQualifiedName(endElement.getName()));
            Iterator<Namespace> i = endElement.getNamespaces();
            while (i.hasNext()) {
                Namespace namespace = i.next();
                this.getContentHandler().endPrefixMapping(namespace.getPrefix());
            }
        }
    }

    private void handleNotationDeclaration(NotationDeclaration declaration) throws SAXException {
        if (this.getDTDHandler() != null) {
            this.getDTDHandler().notationDecl(declaration.getName(), declaration.getPublicId(), declaration.getSystemId());
        }
    }

    private void handleEntityDeclaration(EntityDeclaration entityDeclaration) throws SAXException {
        if (this.getDTDHandler() != null) {
            this.getDTDHandler().unparsedEntityDecl(entityDeclaration.getName(), entityDeclaration.getPublicId(), entityDeclaration.getSystemId(), entityDeclaration.getNotationName());
        }
    }

    private void handleProcessingInstruction(ProcessingInstruction pi) throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().processingInstruction(pi.getTarget(), pi.getData());
        }
    }

    private void handleStartDocument() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().startDocument();
        }
    }

    private void handleStartElement(StartElement startElement) throws SAXException {
        if (this.getContentHandler() != null) {
            Iterator<Namespace> i = startElement.getNamespaces();
            while (i.hasNext()) {
                Namespace namespace = i.next();
                this.getContentHandler().startPrefixMapping(namespace.getPrefix(), namespace.getNamespaceURI());
            }
            this.getContentHandler().startElement(startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart(), QNameUtils.toQualifiedName(startElement.getName()), this.getAttributes(startElement));
        }
    }

    private Attributes getAttributes(StartElement event) {
        AttributesImpl attributes = new AttributesImpl();
        Iterator<Attribute> i = event.getAttributes();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            attributes.addAttribute(attribute.getName().getNamespaceURI(), attribute.getName().getLocalPart(), QNameUtils.toQualifiedName(attribute.getName()), attribute.getDTDType(), attribute.getValue());
        }
        return attributes;
    }
}

